﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;
using nw.g3d.iflib.nw3de;

namespace G3dLibraryTest
{
    [TestClass]
    public class MaterialTest
    {
        [TestMethod]
        public void TestShaderParamReadWrite()
        {
            var sourceFile = new IntermediateFile(IntermediateFileKind.Material);
            Material sourceMat = sourceFile.GetRootEntity<Material>();
            sourceMat.ShaderAssign.ShaderArchive = "hoge";
            sourceMat.ShaderAssign.ShadingModel = "hoge";
            sourceMat.ShaderAssign.ShaderParams.Add(new ShaderParamFloat()
            {
                Id = "paramA",
                Value = 0.5f,
            });

            var writeData = sourceFile.CreateSerializableData();
            var file = new IntermediateFile(writeData);
            var mat = file.GetRootEntity<Material>();
            Assert.AreEqual(sourceMat.ShaderAssign.ShaderArchive, mat.ShaderAssign.ShaderArchive);
            Assert.AreEqual(sourceMat.ShaderAssign.ShadingModel, mat.ShaderAssign.ShadingModel);
            Assert.AreEqual(sourceMat.ShaderAssign.ShaderParams.Count, mat.ShaderAssign.ShaderParams.Count);
            Assert.AreEqual(sourceMat.ShaderAssign.ShaderParams[0].Id, mat.ShaderAssign.ShaderParams[0].Id);
            Assert.AreEqual(sourceMat.ShaderAssign.ShaderParams[0].Type, mat.ShaderAssign.ShaderParams[0].Type);
            Assert.AreEqual((mat.ShaderAssign.ShaderParams[0] as ShaderParamFloat).Value, (mat.ShaderAssign.ShaderParams[0] as ShaderParamFloat).Value);
        }

        [TestMethod]
        public void MaterialReferenceBehaviorConversionTest()
        {
            ToolData toolData = new ToolData();
            var matRefBehavior = new nw3de_MaterialReferenceBehavior();
            toolData.AddToolDataObject(matRefBehavior);

            var behavior = new MaterialReferenceBehavior();
            behavior.MaterialName = "hoge";
            var attrAssignBehavior = new MaterialReferenceBehaviorItem()
            {
                Id = "fuga",
                ChildRestriction = ShaderItemRestrictionState.ForceOverride,
                Value = ShaderItemValueState.Refer,
            };
            behavior.RenderInfoBehaviors = null;
            behavior.SamplerAssignBehaviors = null;
            behavior.SamplerBehaviors = null;
            behavior.ShaderOptionBehaviors = null;
            behavior.ShaderParamBehaviors = null;
            behavior.AttribAssignBehaviors.Add(attrAssignBehavior);
            matRefBehavior.MaterialReferenceBehaviors.Add(behavior);

            {
                var writeData = toolData.CreateSerializableData();
                Assert.AreEqual("nw3de_MaterialReferenceBehavior", writeData.Any[0].Name);
                Assert.AreEqual("MaterialReferenceBehaviors", writeData.Any[0].ChildNodes[0].Name);
                Assert.AreEqual("MaterialReferenceBehavior", writeData.Any[0].ChildNodes[0].ChildNodes[0].Name);
                Assert.AreEqual("MaterialName", writeData.Any[0].ChildNodes[0].ChildNodes[0].Attributes[0].Name);
                Assert.AreEqual(behavior.MaterialName, writeData.Any[0].ChildNodes[0].ChildNodes[0].Attributes[0].Value);
                Assert.AreEqual("AttribAssignBehaviors", writeData.Any[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].Name);
                Assert.AreEqual("AttribAssignBehavior", writeData.Any[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].Name);
                Assert.AreEqual("Id", writeData.Any[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes[0].Name);
                Assert.AreEqual(attrAssignBehavior.Id, writeData.Any[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes[0].Value);
                Assert.AreEqual("Value", writeData.Any[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes[1].Name);
                Assert.AreEqual("Refer", writeData.Any[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes[1].Value);
                Assert.AreEqual("ChildRestriction", writeData.Any[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes[2].Name);
                Assert.AreEqual("ForceOverride", writeData.Any[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes[2].Value);

                var readToolData = new ToolData(writeData);
                var readMatRefBehaivior = readToolData.FindToolDataObject<nw3de_MaterialReferenceBehavior>();
                Assert.IsNotNull(readMatRefBehaivior);
                Assert.AreEqual(behavior.MaterialName, readMatRefBehaivior.MaterialReferenceBehaviors[0].MaterialName);
                Assert.AreEqual(attrAssignBehavior.Id, readMatRefBehaivior.MaterialReferenceBehaviors[0].AttribAssignBehaviors[0].Id);
                Assert.AreEqual(attrAssignBehavior.Value, readMatRefBehaivior.MaterialReferenceBehaviors[0].AttribAssignBehaviors[0].Value);
                Assert.AreEqual(attrAssignBehavior.ChildRestriction, readMatRefBehaivior.MaterialReferenceBehaviors[0].AttribAssignBehaviors[0].ChildRestriction);
            }
        }
    }
}
