﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include <nn/os/os_MemoryHeap.h>
#include <nn/nn_Assert.h>
#include <nn/os/os_Thread.h>

#include "testHtc_CrossBarRunThread.h"

namespace {
    /*
        @brief CrossBar::Run を呼ぶだけのスレッド関数
    */
    void CrossBarRun( void *argument )
    {
        ::tics::CrossBar* pCrossBar = static_cast<::tics::CrossBar*>( argument );
        pCrossBar->Run();
    }
}

/*
    @brief CrossBar::Run() を別スレッドで呼ぶために、
    スタックの確保やスレッドオブジェクトの作成などの一連の処理を行う。
*/
CrossBarRunThread::CrossBarRunThread( ::tics::CrossBar* pCrossBar ) : m_pCrossBar( pCrossBar )
{
    nn::Result result;

    // スタックを確保
    size_t stackSize = ::tics::portability::mem::ThreadStackSize;
    m_Stack = ::tics::portability::mem::ThreadStackAllocate();

    // スレッドオブジェクトの初期化
    result = nn::os::CreateThread( &m_Thread, ::CrossBarRun, m_pCrossBar, m_Stack, stackSize, 0 );
    NN_ASSERT( result.IsSuccess(),  "nn::os::CreateThread() failed.\n" );
}

CrossBarRunThread::~CrossBarRunThread()
{
    nn::os::DestroyThread( &m_Thread );
    ::tics::portability::mem::free(m_Stack);
}

