﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/nntest.h>

#include <nn/os/os_Event.h>

#include "TicsCfg.h"
#include "Plug.h"

class EchoClientPlug : public   ::tics::Plug
{
public:
    /*
        @param[in] pEvent :
            処理終了時にシグナル状態にするイベントへのポインタ。
            nullptr を指定した場合は、イベントをシグナル状態にする処理を行わない。
    */
    explicit EchoClientPlug( nn::os::EventType* pEvent ) : ::tics::Plug()
        , m_pEvent( pEvent )
    {
    }

    void OnSessionStarted (::tics::portability::stl::string type, ::tics::Endpoint* connectedEP);

    int  OnSendComplete(::tics::Buffer* buffer, long offset, long len);

    int OnReceiveComplete(::tics::Buffer* buffer, long offset, long len);

    int OnDetach();

    int OnRemoteDetach();

    const void* GetRecvData();

    void SetSendData(const void* pData, size_t dataSize);

private:
    // 送受信バッファ
    ::tics::Buffer* m_RecvBuffer;
    ::tics::Buffer* m_SendBuffer;

    // 送信データ
    const void* m_pData;
    size_t m_DataSize;

    // 処理終了時にシグナル状態にするイベント
    nn::os::EventType* m_pEvent;
};
