﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/fan/fan_Lib.h>
#include <nn/fan/fan_Control.h>
#include <nn/fan/fan_ControlDev.h>

namespace nn { namespace fan {

namespace {

struct FanData
{
    int rate;

    void Clear() NN_NOEXCEPT
    {
        rate = 0;
    }
};

FanData g_FanData;

} // namespace

void Initialize() NN_NOEXCEPT
{
    g_FanData.Clear();
}

void Finalize() NN_NOEXCEPT
{
}

void OpenController(Controller* pOutController, FanName name) NN_NOEXCEPT
{
    NN_UNUSED(pOutController);
    NN_UNUSED(name);
}

void CloseController(Controller* pController) NN_NOEXCEPT
{
    NN_UNUSED(pController);
}

void SetRotationRate(Controller* pController, int rotationRate) NN_NOEXCEPT
{
    NN_UNUSED(pController);
    g_FanData.rate = rotationRate;
}

int GetRotationRate(Controller* pController) NN_NOEXCEPT
{
    NN_UNUSED(pController);
    return g_FanData.rate;
}

void SetRotationSpeedLevel(Controller* pController, RotationSpeedLevel level) NN_NOEXCEPT
{
    NN_UNUSED(pController);
    g_FanData.rate = static_cast<int>(level);
}

RotationSpeedLevel GetRotationSpeedLevel(Controller* pController) NN_NOEXCEPT
{
    NN_UNUSED(pController);
    return static_cast<RotationSpeedLevel>(g_FanData.rate);
}

RotationSpeedLevel GetActualRotationSpeedLevel(Controller* pController) NN_NOEXCEPT
{
    NN_UNUSED(pController);
    return static_cast<RotationSpeedLevel>(g_FanData.rate);
}

}} // namespace nn::fan
