﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include "abuse_ui_Theme.h"
#include "abuse_ui_HeartBeatView.h"

namespace nnt {
namespace abuse {


// the heart beat status in the footer view
HeartBeatView::HeartBeatView(glv::space_t dim) NN_NOEXCEPT
    : glv::View(glv::Rect(dim, dim))
    , m_Frame(0)
    , m_Alpha(0)
{
    enable(glv::Property::Animate);
    disable(glv::Property::DrawBorder | glv::DrawBack | glv::HitTest);
}

HeartBeatView::~HeartBeatView() NN_NOEXCEPT
{
}

void HeartBeatView::onDraw(glv::GLV& g) NN_NOEXCEPT
{
    glv::draw::color(0.9f, m_Alpha);
    glv::draw::rectangle(0, 0, width(), height());
}

void HeartBeatView::onAnimate(double dsec)
{
    if (m_Frame < 15)
    {
        m_Alpha = 1;
    }
    else if (m_Frame < 30)
    {
        m_Alpha = 0;
    }

    if (++m_Frame >= 60)
    {
        m_Frame = 0;
    }
}

} // ~abuse
} // ~nnt
