﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

namespace nnt {
namespace abuse {

class ContentView : public glv::View
{
    NN_DISALLOW_COPY( ContentView );
    NN_DISALLOW_MOVE( ContentView );

public:
    ContentView(const unsigned width, const unsigned height) NN_NOEXCEPT
        : glv::View(glv::Rect(width, height))
    {
        disable(glv::Property::DrawBack   |
                glv::Property::DrawBorder |
                glv::Property::HitTest    |
                glv::Property::FocusToTop |
                glv::Property::Animate);
    }

    ~ContentView() NN_NOEXCEPT
    {
        // nothing special
    }

    virtual const char *className() const { return "ContentView"; };
};

} // ~abuse
} // ~nnt
