﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <cstring>
#include <Platform.h>
#include <AbuseString.h>

namespace nnt
{
    namespace abuse
    {

        String::String()
            : m_string(nullptr), m_length(0) {}

        String::String(const char* str)
            : m_string(nullptr), m_length(0)
        {
            if(str)
            {
                m_length = strlen(str);
                if(str[0] == '\0')
                    m_length = 0;
                m_string = (char*)Platform::Allocate(m_length + 1);
                strncpy(m_string, str, m_length);
                m_string[m_length] = '\0';
            }
        }

        String::String(const String& string)
            : m_string(nullptr), m_length(string.m_length)
        {
            if(string.m_string)
            {
                m_string = (char*)Platform::Allocate(m_length + 1);
                strncpy(m_string, string.m_string, m_length);
                m_string[m_length] = '\0';
            }
        }

        String::~String()
        {
            if(m_string)
                Platform::Free(m_string);
        }

        String& String::operator=(const String& string)
        {
            if(this != &string)
            {
                if(m_string)
                    Platform::Free(m_string);
                m_length = string.m_length;

                if(string.m_string)
                {
                    m_string = (char*)Platform::Allocate(m_length + 1);
                    strncpy(m_string, string.m_string, m_length);
                    m_string[m_length] = '\0';
                }
            }
            return *this;
        }

        String& String::operator=(const char* cstr)
        {
            if(!cstr)
            {
                m_length = 0;
                m_string=nullptr;
            }
            else
            {
                m_length=strlen(cstr);

                if(m_string)
                    Platform::Free(m_string);
                m_string = (char*)Platform::Allocate(m_length + 1);
                strncpy(m_string, cstr, m_length);
                m_string[m_length]='\0';
            }
            return *this;
        }

        bool String::operator==(const String& string) const
        {
            return strcmp(m_string, string.m_string) == 0;
        }

        bool String::operator==(const char* str) const
        {
            return strcmp(m_string, str) == 0;
        }

        bool String::operator!=(const String& string) const
        {
            return strcmp(m_string, string.m_string) != 0;
        }

        bool String::operator!=(const char* str) const
        {
            return strcmp(m_string, str) != 0;
        }

        char& String::operator[] (unsigned index)
        {
            return m_string[index];
        }

        const char& String::operator[] (unsigned index) const
        {
            return m_string[index];
        }

        unsigned String::length() const
        {
            return (unsigned)m_length;
        }

        const char* String::c_str() const
        {
            return m_string;
        }
    }
}
