﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/nn_Log.h>
#include <Abuse.h>
#include <FileUtility.h>
#include <ShellServer.h>
#include <AbuseDriver.h>
namespace nnt
{
    namespace abuse
    {
        AbuseDriver::AbuseDriver(int core, ListActiveTask* taskList, int64_t* heartbeats)
            :m_activeTasks(taskList), m_heartbeats(heartbeats), m_core(core)
        {
        }

        AbuseDriver::~AbuseDriver()
        {
        }

        BaseTask* AbuseDriver::ChooseTask()
        {
            BaseTask* out = nullptr;
            auto itr = m_activeTasks->begin();
            while(itr != m_activeTasks->end())
            {
                if(itr->task->GetProcessor() == m_core &&  itr->task->CanRun() && !itr->task->IsSuspended())
                {
                    out = itr->task;
                    itr = m_activeTasks->erase(itr);
                    break;
                }
                ++itr;
            }
            bool outInserted=false;
            //promote remaining tasks non-running
            while(itr != m_activeTasks->end())
            {
                if(!outInserted && out && itr->task->GetCurrentPriority() > out->GetCurrentPriority())
                {
                    m_activeTasks->insert(itr, out);
                    outInserted = true;
                }
                if( itr->task->GetProcessor() == m_core && itr->task->CanRun() && !itr->task->IsRunning())
                    itr->task->RaisePriority();
                ++itr;
            }
            if(!outInserted && out != nullptr)
                m_activeTasks->push_back(out);

            return out;
        }

        bool AbuseDriver::ShouldUpkeep()
        {
            int64_t timeout = Platform::GetSystemRunningTimeMilli() + 300;

            for(int i = 0; i < Platform::GetNumCores(); ++i)
            {
                if( timeout > m_heartbeats[i] )
                    continue;
                //return true;
            }
            return m_core == 0;
        }

        int AbuseDriver::GetCore()
        {
            return m_core;
        }

        bool AbuseDriver::timedOut(int core)
        {
            if(m_core == core)
                return false;

            int64_t timeNow = Platform::GetSystemRunningTimeMilli();

            if(timeNow - m_heartbeats[core] < Abuse::GetTimeoutDuration())
                return true;
            return false;
        }
    }
}
