﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <Tasks/BaseTask.h>
namespace nnt
{
    namespace abuse
    {
        class OsMemoryTask;
        struct MemoryThreadArg
        {
            OsMemoryTask* task;
            int           startSize;
            int           endSize;
            int           stepSize;
        };

        class OsMemoryTask : public BaseTask
        {
        private:
                static const int MB = 1024 * 1024;
                static const int GB = MB * 1024;
        public:
            OsMemoryTask(const String& typeName, const String& instanceName);
            virtual ~OsMemoryTask();

            virtual InitStatus Initialize(const String& params);
            virtual StartStatus Start();
            virtual RunStatus Run();
            virtual StopStatus Stop();
            virtual ShutdownStatus Shutdown();

            virtual const char* GetParamOptions();
        private:
            static void workerFunc(void* arg);
            nn::Result lockedAllocate(uintptr_t* addr, int size);
            void lockedFree(uintptr_t addr, int size);

            MemoryThreadArg*     m_threadArgs;
            nn::os::ThreadType*  m_threads;
            void**               m_stacks;
            nn::os::MutexType    m_memoryMutex;
            int                  m_heapSize;
            int                  m_bytesAllocated;
            int                  m_numThreads;
            int                     m_maxThreads;
            int                  m_numActualThreads;
            int                  m_priority;
        };
    }
}
