﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/os.h>
#include <nn/htcs.h>
#include <vector>
#include <list>
#include <Platform.h>
namespace nnt
{
    namespace abuse
    {
        enum ShellCommandType
        {
            SHELL_INVALID = -1,
            SHELL_SCRIPT_FILE = 0,
            SHELL_RUN_SCRIPT_COMMAND,
            SHELL_STOP_SCRIPT,
            SHELL_EXIT_ABUSE,
            SHELL_INIT_MONITOR,
            SHELL_GET_AVAILABLE_TASKS,
            //SHELL_GET_RUNNING_TASKS,
            //SHELL_GET_STATUS,
        };

        //Must be [0,255]
        enum ShellPacketType
        {
            PACKET_ACK_FAIL=0,
            PACKET_ACK_PASS,
            PACKET_ACK_CONTINUE,
            PACKET_STRING,
            PACKET_INIT_MONITOR,
            PACKET_AVAILABLE_TASKS,
            PACKET_STATUS,
            PACKET_ACTIVE_TASKS,
            PACKET_TASKLIST_FINISHED,
        };

        struct RegisteredShellCommand
        {
            RegisteredShellCommand(ShellCommandType _type, const char* _name) : type(_type), name(_name){}
            ShellCommandType type;
            const char* name;
        };

        struct ShellCommand
        {
            ShellCommand(ShellCommandType _command, const char* _args, int _commandIndex, int _socket, int _id)
            :  type(_command), args(_args), commandIndex(_commandIndex), socket(_socket), id(_id){}
            ShellCommandType type;
            String args;
            int commandIndex;
            int socket;
            int id;
        };

        struct ShellPacketHeader
        {
            char data[3];
        };

        class ShellServer
        {
        public:
            ShellServer();
            ~ShellServer();
            bool Initialize(uint16_t listenPort = 8020);
            void Finalize();
            bool IsInitialized();


            int SendString(int socket, const char* format, ...);
            int SendReply(int socket, ShellPacketType type, const char* format, uint16_t length);
            int SendCommandResult(int socket, bool passed, const char* format, ...);

            bool IsCommandPending();
            const ShellCommand& PeekNextCommand();
            void PopNextCommand();

            void UpdateServer();
        private:
            int sendPacket(int socket,char* buffer, uint16_t bufferSize, ShellPacketType type);
            ShellCommand parseCommand(const char* buffer, int socket);

            std::vector<int, PlatformAllocator<int>> m_clientSockets;
            std::list<ShellCommand, PlatformAllocator<ShellCommand>> m_pendingCommands;
            nn::os::MutexType m_clientMutex;
            int m_nextId;
            int m_serverSocket;
            bool m_initialized;
            bool m_running;
        };
    }
}
