﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/os.h>
#include <new>

#include <Platform.h>
#include <list>
#include <vector>

#include <Commands/CommandCommon.h>
#include <Commands/CommandWait.h>
#include <Commands/CommandCreateTask.h>
#include <Commands/CommandLoop.h>
#include <Commands/CommandSuspendTask.h>
#include <Commands/CommandResumeTask.h>
#include <Commands/CommandKillTask.h>
namespace nnt
{
    namespace abuse
    {

        class BaseCommand;

        static RegisteredCommand validCommands[] = {
            RegisteredCommand("WAIT", COMMAND_WAIT, CreateCommand<CommandWait>),
            RegisteredCommand("STARTLOOP", COMMAND_START_LOOP, CreateCommand<CommandStartLoop>),
            RegisteredCommand("ENDLOOP", COMMAND_END_LOOP, CreateCommand<CommandEndLoop>),
            RegisteredCommand("CREATE", COMMAND_CREATE_TASK, CreateCommand<CommandCreateTask>),
            RegisteredCommand("KILLALLTASKS", COMMAND_KILL_ALL_TASKS, CreateCommand<CommandKillAllTasks>),
            RegisteredCommand("KILL", COMMAND_KILL_TASK, CreateCommand<CommandKillTask>),
            RegisteredCommand("SUSPENDALLTASKS", COMMAND_SUSPEND_ALL_TASKS, CreateCommand<CommandSuspendAllTasks>),
            RegisteredCommand("SUSPEND", COMMAND_SUSPEND_TASK, CreateCommand<CommandSuspendTask>),
            RegisteredCommand("RESUMEALLTASKS", COMMAND_RESUME_ALL_TASKS, CreateCommand<CommandResumeAllTasks>),
            RegisteredCommand("RESUME", COMMAND_RESUME_TASK, CreateCommand<CommandResumeTask>),
        };

    }
}
