﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
namespace nnt
{
    namespace abuse
    {
        class String
        {
        public:
            String();
            NN_IMPLICIT String(const char* str);
            NN_IMPLICIT String(const String& string);
            ~String();

            String& operator=(const String& string);
            String& operator=(const char* cstr);

            bool operator==(const String& string) const;
            bool operator==(const char* str) const;

            bool operator!=(const String& string) const;
            bool operator!=(const char* str) const;

            char& operator[](unsigned index);
            const char& operator[](unsigned index) const;
            unsigned length() const;
            const char* c_str() const;
        private:
            char* m_string;
            size_t m_length;
        };
    }
}
