﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "sdmmc_Result.h"

namespace nn { namespace sdmmc1 {

    const size_t SectorSize = 512;

    enum Port
    {
        Port_Mmc0,
        Port_SdCard0
    };

    // 対応していない環境で実行すると ABORT します。
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    Result Activate(Port port) NN_NOEXCEPT;
    void Deactivate(Port port) NN_NOEXCEPT;
    Result Read(void* pOutBuffer, size_t bufferSize, Port port, uint32_t sectorIndex, uint32_t numSectors) NN_NOEXCEPT;
    Result Write(Port port, uint32_t sectorIndex, uint32_t numSectors, const void* pData, size_t dataSize) NN_NOEXCEPT;

}} // namespace nn { namespace sdmmc1 {
