﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"

TEST(SetHeapSizeTest, ReleaseMemoryAreaTest)
{
    nn::Result result;
    nn::svc::MemoryInfo info;
    uintptr_t addr;
    uintptr_t tmp;

    result = nn::svc::SetHeapSize(&addr, HeapAlign);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 1-13
    // 解放される領域は一様にReadWrite パーミッションでなければならない
    result = nn::svc::SetHeapSize(&addr, HeapAlign * 2);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SetMemoryPermission(addr + HeapAlign, HeapAlign,
            nn::svc::MemoryPermission_Read);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SetHeapSize(&tmp, 0);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

    result = nn::svc::SetMemoryPermission(addr + HeapAlign, HeapAlign,
            nn::svc::MemoryPermission_ReadWrite);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SetHeapSize(&addr, 0);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 1-14
    // 解放される領域は一様にReadWrite パーミッションでなければならない
    result = nn::svc::SetHeapSize(&addr, HeapAlign);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SetMemoryPermission(addr, HeapAlign,
            nn::svc::MemoryPermission_Read);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SetHeapSize(&tmp, 0);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

    result = nn::svc::SetMemoryPermission(addr, HeapAlign,
            nn::svc::MemoryPermission_ReadWrite);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SetHeapSize(&addr, 0);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 1-18
    // 解放するヒープ領域は属性が付加されていると失敗する
    result = nn::svc::SetHeapSize(&addr, HeapAlign);
    ASSERT_RESULT_SUCCESS(result);

    {
        TestMapMemory map(g_FreeAreaBegin, addr, 0x1000);

        GetMemoryInfo(&info, addr);
        ASSERT_TRUE(info.state == nn::svc::MemoryState_Normal);
        ASSERT_TRUE(info.permission == nn::svc::MemoryPermission_None);
        ASSERT_TRUE(info.attribute == nn::svc::MemoryAttribute_Locked);

        result = nn::svc::SetHeapSize(&tmp, 0);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());
    }

    GetMemoryInfo(&info, addr);
    ASSERT_TRUE(info.state == nn::svc::MemoryState_Normal);
    ASSERT_TRUE(info.permission == nn::svc::MemoryPermission_ReadWrite);
    ASSERT_TRUE(info.attribute == 0);

    result = nn::svc::SetHeapSize(&addr, 0);
    ASSERT_RESULT_SUCCESS(result);
}

#ifdef INVALID_MEMORY_ACCESS_TEST
/* TEST 1-11 */
/* 縮小した領域にアクセスできないことを確認 */
TEST(SetHeapSizeTest, InvalidMemoryAccessTest)
{
    nn::Result result;
    uintptr_t addr;
    int32_t *data;

    result = nn::svc::SetHeapSize(&addr, HeapAlign * 2);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::SetHeapSize(&addr, HeapAlign);
    data = reinterpret_cast<int32_t*>(addr + HeapAlign);
    *data = 1;
}
#endif

