﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Compiler.h>
#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>

namespace {
const char* testString = "test";
}
extern "C" void nnMain();

#if defined NN_BUILD_CONFIG_COMPILER_CLANG
#pragma clang diagnostic ignored "-Wtautological-compare"
#endif

// 自プロセスに対するQueryProcessMemory
TEST(QueryProcessMemory, NormalTest)
{
    uintptr_t addr;
    uintptr_t v;
    size_t size;
    nn::Result result;
    int i;
    nn::svc::MemoryInfo blockInfo;
    nn::svc::PageInfo pageInfo;
    nnHandle handle = { 0xFFFF8001 };

    size = HeapAlign;
    result = nn::svc::SetHeapSize(&addr, size);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 118-39
    // 全アドレス空間を4Kごとにチェック
    v = CheckVirtualBegin;
    do
    {
        result = nn::svc::QueryProcessMemory(&blockInfo, &pageInfo, static_cast<nn::svc::Handle>(handle), v);
        if (ProcessBegin <= v && v <= ProcessEnd)
        {
            ASSERT_RESULT_SUCCESS(result);
            // TEST 118-28
            // MemoryState_Code の領域の情報を取得できる
            if (blockInfo.baseAddress <= reinterpret_cast<uintptr_t>(&nnMain) && reinterpret_cast<uintptr_t>(&nnMain) <= blockInfo.baseAddress + blockInfo.size - 1)
            {
                ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_ReadExecute);
                ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);
            }
            // TEST 118-28
            // MemoryState_Code の領域の情報を取得できる
            else if (blockInfo.baseAddress <= reinterpret_cast<uintptr_t>(testString) && reinterpret_cast<uintptr_t>(testString) <= blockInfo.baseAddress + blockInfo.size - 1)
            {
                ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_Read);
                ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);
            }
            // TEST 118-25
            // MemoryState_Normal の領域の情報を取得できる
            // TEST 118-31
            // MemoryState_Stack の領域の情報を取得できる
            else if (blockInfo.baseAddress <= reinterpret_cast<uintptr_t>(&i) && reinterpret_cast<uintptr_t>(&i) <= blockInfo.baseAddress + blockInfo.size - 1)
            {
                ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_ReadWrite);
                ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Stack || blockInfo.state == nn::svc::MemoryState_Normal);
            }
            // TEST 118-25
            // MemoryState_Normal の領域の情報を取得できる
            else if (blockInfo.baseAddress <= addr && addr <= blockInfo.baseAddress + blockInfo.size - 1)
            {
                ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_ReadWrite);
                ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Normal);
            }
        }
        else
        {
            ASSERT_RESULT_SUCCESS(result);
            ASSERT_TRUE(blockInfo.baseAddress == ProcessEnd + 1);
            ASSERT_TRUE(blockInfo.size == (0 - (ProcessEnd + ProcessBegin + 1)));
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Inaccessible);
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
        }
        v += 0x1000;
    } while (v != CheckVirtualEnd);

    result = nn::svc::SetHeapSize(&addr, 0);
    ASSERT_RESULT_SUCCESS(result);
}

