﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/TargetConfigs/build_Fpu.h>
#include <nn/svc/svc_BaseId.autogen.h>

#if defined NN_BUILD_CONFIG_CPU_ARM64
    .section .text, "ax"
    .align   2
    .global  NotBool
    .type    NotBool, %function
NotBool:
    mvn     w8, w0
    and     w0, w8, #1
    ret
    .size   NotBool, [. - NotBool]
#else
    .section .text, "ax"
    .align   2
    .global  NotBool
    .type    NotBool, %function
NotBool:
    eor     r0, r0, #1 
    bx      lr
    .size   NotBool, [. - NotBool]
#endif

    .section .text, "ax"
    .align   12
    .global  IpcHeaderAsm
    .type    IpcHeaderAsm, %function
IpcHeaderAsm:
    .word   0x00000001
    .word   0x00000000
    .size   IpcHeaderAsm, [. - IpcHeaderAsm]

