﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "test_ManageNamedPort.h"
#include <nn/svc/ipc/svc_SessionMessage.h>
#include <nn/init.h>

extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

namespace {

const int64_t SleepTime = 100 * 1000 * 1000;

} // namespace

uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

extern "C" void nnMain()
{
    InitTestMemory();

    nn::Result result;

    NN_LOG("Start Client\n");

    nn::svc::Handle clientSession;
    do
    {
        nn::svc::SleepThread(SleepTime);
        result = nn::svc::ConnectToNamedPort(&clientSession, PortName);
    } while(result.IsFailure());

    nn::svc::Handle portHandle;
    result = nn::svc::ManageNamedPort(&portHandle, DelPortName, 1);
    NN_ASSERT_RESULT_SUCCESS(result);

    nn::Bit32* pMsgBuffer = nn::svc::ipc::GetMessageBuffer();
    nn::svc::ipc::MessageBuffer ipcMsg(pMsgBuffer);

    nn::svc::ipc::MessageBuffer::MessageHeader ipcHeader(0x0001, 1, 0, 0, 0, 0, 0, 0);
    nn::svc::ipc::MessageBuffer::SpecialHeader ipcSpecial(false, 1, 0);
    int offset = ipcMsg.Set(ipcHeader);
    offset = ipcMsg.Set(ipcSpecial);
    offset = ipcMsg.SetHandle(offset, nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);

    result = nn::svc::SendSyncRequest(clientSession);
    DebugResult(result);
    NN_ASSERT_RESULT_SUCCESS(result);

    // Server が終了させるのを待つ
    for(;;)
    {
        nn::svc::SleepThread(SleepTime);
    }
}
