﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"

namespace {
char g_Buffer[DefaultStackSize] __attribute__((aligned(0x1000)));
uint32_t g_ThreadId;
uint32_t g_ProcessId;
const int NumTest = 10000;

void TestThreadId()
{
    AutoThreadExit autoExit;
    nn::Result result;
    nnHandle handle;
    handle.value = 0xFFFF8000;

    nn::Bit64 id;
    result = nn::svc::GetThreadId(&id, static_cast<nn::svc::Handle>(handle));
    ASSERT_RESULT_SUCCESS(result);
    g_ThreadId = id;

    handle.value = 0xFFFF8001;
    result = nn::svc::GetProcessId(&id, static_cast<nn::svc::Handle>(handle));
    ASSERT_RESULT_SUCCESS(result);
    g_ProcessId = id;

}
}

TEST(ThreadId, Test0)
{
    TestThreadLeak leakTest;
    nn::Result result;
    nn::Bit64 currentId;
    nn::Bit64 currentPid;
    nn::Bit64 dummy;

    {
        nnHandle handle;
        // TEST 32-1
        // 自スレッドの ID が取得できることの確認
        handle.value = 0xFFFF8000;
        result = nn::svc::GetThreadId(&currentId, static_cast<nn::svc::Handle>(handle));
        ASSERT_RESULT_SUCCESS(result);


        // TEST 32-2
        // PSEUDO_HANDLE_CURRENT_PROCESS を引数に与えると成功することの確認
        handle.value = 0xFFFF8001;
        result = nn::svc::GetProcessId(&currentPid, static_cast<nn::svc::Handle>(handle));
        ASSERT_RESULT_SUCCESS(result);

        // TEST 32-1
        // PSEUDO_HANDLE_CURRENT_THREAD を引数に与えると成功することの確認
        handle.value = 0xFFFF8000;
        result = nn::svc::GetProcessId(&dummy, static_cast<nn::svc::Handle>(handle));
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(dummy == currentPid);

        handle.value = 0xFFFF8001;
        result = nn::svc::GetThreadId(&dummy, static_cast<nn::svc::Handle>(handle));
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());
    }

    for (int i = 0; i < NumTest; i++)
    {
        for (int32_t idealCore = 0; idealCore < NumCore; idealCore++)
        {
            uintptr_t sp = reinterpret_cast<uintptr_t>(g_Buffer + sizeof(g_Buffer));
            uintptr_t pc = reinterpret_cast<uintptr_t>(TestThreadId);
            nn::svc::Handle handle;
            nn::Bit64 id;

            result = nn::svc::CreateThread(&handle, pc, 0, sp, 32, idealCore);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::StartThread(handle);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::GetThreadId(&id, handle);
            ASSERT_RESULT_SUCCESS(result);

            int32_t index;
            result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
            ASSERT_RESULT_SUCCESS(result);
            // TEST 32-3 (同じコア) 32-4 (別のコア)
            // 作成したスレッドで取得した ID と作成者のスレッドで取得した ID が等しいことを確認
            ASSERT_TRUE(id == g_ThreadId);

            // TEST 31-3 (同じコア) 31-4 (別のコア)
            // 作成したスレッドで取得した ID と作成者のスレッドで取得したID が等しいことを確認
            ASSERT_TRUE(g_ProcessId == currentPid);
            ASSERT_TRUE(id != currentId);

            result = nn::svc::CloseHandle(handle);
            ASSERT_RESULT_SUCCESS(result);
        }
    }
}

