﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_HardwareParamsSelect.h>
#include <nn/svc/svc_InterruptNameSelect.h>
#include <nn/util/util_BitPack.h>
#include <nn/svc/svc_Dd.h>
#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_NX )
#include "test_TestTmrDevice_Jetson.h"
#endif

#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_NX )
namespace {

extern "C" void nnMain();

} // namespace

#ifdef INVALID_POINTER_TEST
TEST(CreateInterruptEvent, InvalidPointerTest)
{
    TestInterruptEventLeak leakTest;
    nn::Result result;
    nn::svc::Handle* handle;
#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_NX )
    int32_t name = TmrDefaultInterruptNumber;
#else
#error not implemented
#endif
    nn::svc::InterruptType type = nn::svc::InterruptType_Level;

    // 念のためテスト
    nn::svc::Handle tmpHandle;
    result = nn::svc::CreateInterruptEvent(&tmpHandle, name, type);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(tmpHandle);
    ASSERT_RESULT_SUCCESS(result);

#ifdef INVALID_POINTER_TEST
    // TEST 81-3
    // NULL アドレスを受け付けない
    result = nn::svc::CreateInterruptEvent(NULL, name, type);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 81-4
    // MemoryPermission_None の領域を渡すと失敗する
    handle = reinterpret_cast<nn::svc::Handle*>(g_FreeAreaBegin);
    result = nn::svc::CreateInterruptEvent(handle, name, type);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 81-5
    // MemoryPermission_Read の領域を渡すと失敗する
    {
        TestHeap heap(HeapAlign);
        uintptr_t addr = heap.GetAddress();
        {
            TestMemoryPermission perm(addr, 0x1000, nn::svc::MemoryPermission_Read);
            handle = reinterpret_cast<nn::svc::Handle*>(addr);
            result = nn::svc::CreateInterruptEvent(handle, name, type);
            ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
        }
    }
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 81-6
    // MemoryPermission_ReadExecute の領域を渡すと失敗する
    handle = reinterpret_cast<nn::svc::Handle*>(nnMain);
    result = nn::svc::CreateInterruptEvent(handle, name, type);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

}
#endif // INVALID_POINTER_TEST

TEST(CreateInterruptEvent, InvalidType)
{
    TestInterruptEventLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;
#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_NX )
    int32_t name = TmrDefaultInterruptNumber;
#else
#error not implemented
#endif

    nn::svc::InterruptType type = static_cast<nn::svc::InterruptType>(0xdead);

    // TEST 81-10
    // type が InterruptType のメンバではないと失敗する
    result = nn::svc::CreateInterruptEvent(&handle, name, type);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidEnum());
}
#endif // NN_BUILD_CONFIG_HARDWARE_JETSONTK1
