﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>

namespace {

const int64_t WaitTime = 0;

char g_Buffer[DefaultStackSize] __attribute__((aligned(0x1000)));

void TestThreadFunction0(uintptr_t arg)
{
    NN_UNUSED(arg);
    AutoThreadExit autoExit;
}

}

TEST(ClearEvent, ClearNotSignaledEventTest)
{
    TestEventLeak leakTest;
    nn::Result result;
    nn::svc::Handle readHandle;
    nn::svc::Handle writeHandle;
    int32_t index;

    result = nn::svc::CreateEvent(&writeHandle, &readHandle);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::WaitSynchronization(&index, &readHandle, 1, WaitTime);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultTimeout());

    // TEST 16-7
    // シグナル状態にないイベントをクリアできる。
    result = nn::svc::ClearEvent(readHandle);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::WaitSynchronization(&index, &readHandle, 1, WaitTime);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultTimeout());

    // TEST 16-8
    // シグナル状態にないイベントをクリアできる。
    result = nn::svc::ClearEvent(writeHandle);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::WaitSynchronization(&index, &readHandle, 1, WaitTime);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultTimeout());

    result = nn::svc::CloseHandle(writeHandle);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(readHandle);
    ASSERT_RESULT_SUCCESS(result);
}

TEST(ClearEvent, InvalidHandleTest)
{
    TestEventLeak leakTest;
    nn::Result result;

    // TEST 16-13
    result = nn::svc::ClearEvent(nn::svc::INVALID_HANDLE_VALUE);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 16-14
    result = nn::svc::ClearEvent(nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 16-15
    result = nn::svc::ClearEvent(nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // Event ハンドル
    {
        nn::svc::Handle readHandle;
        nn::svc::Handle writeHandle;

        result = nn::svc::CreateEvent(&writeHandle, &readHandle);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::CloseHandle(writeHandle);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::CloseHandle(readHandle);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 16-24
        result = nn::svc::ClearEvent(readHandle);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

        // TEST 16-25
        result = nn::svc::ClearEvent(writeHandle);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());
    }

    // Thread ハンドル
    {
        nn::svc::Handle threadHandle;
        uintptr_t sp = reinterpret_cast<uintptr_t>(g_Buffer + sizeof(g_Buffer));
        uintptr_t pc = reinterpret_cast<uintptr_t>(TestThreadFunction0);

        result = nn::svc::CreateThread(&threadHandle, pc, 0, sp,
                TestLowestThreadPriority, 0);
        ASSERT_RESULT_SUCCESS(result);

        // TEST 16-26
        result = nn::svc::ClearEvent(threadHandle);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

        // TEST 16-18
        result = nn::svc::CloseHandle(threadHandle);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::ClearEvent(threadHandle);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());
    }

    // Process ハンドル
    {
        TestProcess process(1);

        // TEST 16-27
        // プロセスのハンドルを受け付けない
        result = nn::svc::ClearEvent(process.GetHandle());
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

        // TEST 16-28
        // Close したプロセスのハンドルを受け付けない
        result = nn::svc::CloseHandle(process.GetHandle());
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::ClearEvent(process.GetHandle());
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());
    }
}
