﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"

extern "C" void nnMain();

namespace {
} // namespace

TEST(ArbitrateUnlock, AddressTest)
{
    nn::Result result;
    uintptr_t addr;
    size_t align = 4;
    size_t size = 0x1000;

    TestHeap heap(HeapAlign);
    addr = heap.GetAddress();
    ASSERT_TRUE((addr % align) == 0);
    nn::Bit32* ptr = reinterpret_cast<nn::Bit32*>(addr);
    *ptr = 0;

    // TEST 137-1
    // 4B にアライメントされている値を受け付ける
    for (uintptr_t i = 0; i < 0x100; i += align)
    {
        ptr = reinterpret_cast<nn::Bit32*>(addr + i);
        *ptr = 1;
        result = nn::svc::ArbitrateUnlock(addr + i);
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(*ptr == 0);
    }

    // TEST 137-2
    // 4B にアライメントされていないと失敗する
    for (uintptr_t i = 1; i < align; i++)
    {
        ptr = reinterpret_cast<nn::Bit32*>(addr + i);
        *ptr = 1;
        result = nn::svc::ArbitrateUnlock(addr + i);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidAddress());
        ASSERT_TRUE(*ptr == 1);
    }

    ptr = reinterpret_cast<nn::Bit32*>(addr);
    *ptr = 1;

    // TEST 137-3
    // MemoryPermission_None の領域は受け付けない
    {
        TestMemoryPermission perm(addr, size, nn::svc::MemoryPermission_None);
        result = nn::svc::ArbitrateUnlock(addr);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());
    }
    ASSERT_TRUE(*ptr == 1);

    // TEST 135-10
    // MemoryPermission_Read の領域は受け付けない
    {
        TestMemoryPermission perm(addr, size, nn::svc::MemoryPermission_Read);
        result = nn::svc::ArbitrateUnlock(addr);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());
    }
    ASSERT_TRUE(*ptr == 1);

    // TEST 135-13
    // MemoryPermission_ReadWrite の領域を受け付ける
    {
        TestMemoryPermission perm(addr, size, nn::svc::MemoryPermission_ReadWrite);
        result = nn::svc::ArbitrateUnlock(addr);
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(*ptr == 0);
        *ptr = 1;
    }

    // TEST 135-14
    // MemoryPermission_ReadExecute の領域は受け付けない
    {
        addr = reinterpret_cast<uintptr_t>(nnMain);
        addr = (addr + (align - 1)) & ~(align - 1);
        result = nn::svc::ArbitrateUnlock(addr);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());
    }
}

