﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "sdmmc_Mmc.h"
#include <nn/TargetConfigs/build_Base.h>
#include "detail/sdmmc_MmcDeviceAccessor.h"
#if (defined(NN_DETAIL_SDMMC_PORT_MMC_0_ENABLE))
    #include "detail/sdmmc_PortMmc0.h"
#endif
#if (defined(NN_DETAIL_SDMMC_PORT_SD_CARD_0_ENABLE))
    #include "detail/sdmmc_PortSdCard0.h"
#endif
#if (defined(NN_DETAIL_SDMMC_PORT_GC_ASIC_0_ENABLE))
    #include "detail/sdmmc_PortGcAsic0.h"
#endif
#include <nn/nn_Abort.h>

namespace nn { namespace sdmmc1 {

namespace
{
    detail::MmcDeviceAccessor* GetMmcDeviceAccessor(Port port) NN_NOEXCEPT
    {
        detail::MmcDeviceAccessor* pMmcDeviceAccessor = nullptr;
        switch (port)
        {
        #if (defined(NN_DETAIL_SDMMC_PORT_MMC_0_ENABLE))
            case Port_Mmc0:
                pMmcDeviceAccessor = detail::GetMmcDeviceAccessorOfPortMmc0();
                break;
        #endif
        #if (defined(NN_DETAIL_SDMMC_PORT_SD_CARD_0_ENABLE) && defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_SD_CARD_0_FOR_DEBUG))
            case Port_SdCard0:
                pMmcDeviceAccessor = detail::GetMmcDeviceAccessorOfPortSdCard0();
                break;
        #endif
        #if (defined(NN_DETAIL_SDMMC_PORT_GC_ASIC_0_ENABLE) && defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_GC_ASIC_0_FOR_DEBUG))
            case Port_GcAsic0:
                pMmcDeviceAccessor = detail::GetMmcDeviceAccessorOfPortGcAsic0();
                break;
        #endif
        default:
            NN_UNEXPECTED_DEFAULT;
        }
        NN_ABORT_UNLESS_NOT_NULL(pMmcDeviceAccessor);
        return pMmcDeviceAccessor;
    }
}

Result ActivateMmc(Port port, void* pMmcWorkBuffer, size_t mmcWorkBufferSize) NN_NOEXCEPT
{
    detail::MmcDeviceAccessor* pMmcDeviceAccessor = GetMmcDeviceAccessor(port);
    return pMmcDeviceAccessor->ActivateMmc(pMmcWorkBuffer, mmcWorkBufferSize);
}

Result GetMmcSpeedMode(SpeedMode* pOutSpeedMode, Port port, void* pMmcWorkBuffer, size_t mmcWorkBufferSize) NN_NOEXCEPT
{
    detail::MmcDeviceAccessor* pMmcDeviceAccessor = GetMmcDeviceAccessor(port);
    return pMmcDeviceAccessor->GetMmcSpeedMode(pOutSpeedMode, pMmcWorkBuffer, mmcWorkBufferSize);
}

Result SelectMmcPartition(Port port, MmcPartition mmcPartition) NN_NOEXCEPT
{
    detail::MmcDeviceAccessor* pMmcDeviceAccessor = GetMmcDeviceAccessor(port);
    return pMmcDeviceAccessor->SelectMmcPartition(mmcPartition);
}

Result GetMmcBootPartitionCapacity(uint32_t* pOutNumSectors, Port port, void* pMmcWorkBuffer, size_t mmcWorkBufferSize) NN_NOEXCEPT
{
    detail::MmcDeviceAccessor* pMmcDeviceAccessor = GetMmcDeviceAccessor(port);
    return pMmcDeviceAccessor->GetMmcBootPartitionCapacity(pOutNumSectors, pMmcWorkBuffer, mmcWorkBufferSize);
}

Result GetMmcExtendedCsd(void* pOutExtendedCsdBuffer, size_t extendedCsdBufferSize, Port port) NN_NOEXCEPT
{
    detail::MmcDeviceAccessor* pMmcDeviceAccessor = GetMmcDeviceAccessor(port);
    return pMmcDeviceAccessor->GetMmcExtendedCsd(pOutExtendedCsdBuffer, extendedCsdBufferSize);
}

}} // namespace nn { namespace sdmmc1 {
