﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "../sdmmc_Common.h"

namespace nn { namespace sdmmc1 {
namespace detail {

// SD Host Standard Register
// Specification Varsion 4.00 準拠
struct SdHostStandardRegisters
{
    volatile uint32_t   sdmaSystemAddress;                  // 000h
    volatile uint16_t   blockSize;                          // 004h
    volatile uint16_t   blockCount;                         // 006h
    volatile uint32_t   argument1;                          // 008h
    volatile uint16_t   transferMode;                       // 00Ch
    volatile uint16_t   command;                            // 00Eh
    volatile uint32_t   response10;                         // 010h
    volatile uint32_t   response32;                         // 014h
    volatile uint32_t   response54;                         // 018h
    volatile uint32_t   response76;                         // 01Ch
    volatile uint32_t   bufferDataPort;                     // 020h
    volatile uint32_t   presentState;                       // 024h
    volatile uint8_t    hostControl1;                       // 028h
    volatile uint8_t    powerControl;                       // 029h
    volatile uint8_t    blockGapControl;                    // 02Ah
    volatile uint8_t    wakeupControl;                      // 02Bh
    volatile uint16_t   clockControl;                       // 02Ch
    volatile uint8_t    timeoutControl;                     // 02Eh
    volatile uint8_t    softwareReset;                      // 02Fh
    volatile uint16_t   normalInterruptStatus;              // 030h
    volatile uint16_t   errorInterruptStatus;               // 032h
    volatile uint16_t   normalInterruptStatusEnable;        // 034h
    volatile uint16_t   errorInterruptStatusEnable;         // 036h
    volatile uint16_t   normalInterruptSignalEnable;        // 038h
    volatile uint16_t   errorInterruptSignalEnable;         // 03Ah
    volatile uint16_t   autoCmdErrorStatus;                 // 03Ch
    volatile uint16_t   hostControl2;                       // 03Eh
    volatile uint32_t   capabilities10;                     // 040h
    volatile uint32_t   capabilities32;                     // 048h
    volatile uint32_t   maximumCurrentCapabilities10;       // 048h
    volatile uint32_t   maximumCurrentCapabilities32;       // 04Ch
    volatile uint16_t   forceEventForAutoCmdErrorStatus;    // 050h
    volatile uint16_t   forceEventForErrorInterruptStatus;  // 052h
    volatile uint8_t    admaErrorStatus;                    // 054h
    volatile uint8_t    reserved0[3];
    volatile uint32_t   admaSystemAddressLow;               // 058h
    volatile uint32_t   admaSystemAddressHigh;              // 05Ch
    volatile uint8_t    reserved1[0x88];
    volatile uint16_t   PointerForVendorSpecificArea;       // 0E8h
    volatile uint8_t    reserved2[0x12];
    volatile uint16_t   slotInterruptStatus;                // 0FCh
    volatile uint16_t   hostControllerVersion;              // 0FEh
};

// 004h Block Size Register ビット定義
#if (defined(NN_DETAIL_SDMMC_EXPECT_SMMU_ENABLED))
    // const uint16_t REG_BLOCK_SIZE__SDMA_BUFFER_BOUNDARY__DEF = 0x7U << 12;  // 512KB = SdmaBufferBoundary
    const uint16_t REG_BLOCK_SIZE__SDMA_BUFFER_BOUNDARY__DEF = 0x0U << 12;  // 512KB = SdmaBufferBoundary
    // const size_t SdmaBufferBoundary = 512 * 1024;
    const size_t SdmaBufferBoundary = 0x1000;
#elif (defined(NN_DETAIL_SDMMC_BUFFER_ADDRESS_IS_PHYSICAL))
    const uint16_t REG_BLOCK_SIZE__SDMA_BUFFER_BOUNDARY__DEF = 0x0U << 12;  // 4KB = SdmaBufferBoundary
    const size_t SdmaBufferBoundary = 4 * 1024;
#else   // 自ら論物変換する場合
    const uint16_t REG_BLOCK_SIZE__SDMA_BUFFER_BOUNDARY__DEF = 0x0U << 12;  // 4KB = SdmaBufferBoundary
    const size_t SdmaBufferBoundary = 4 * 1024;
#endif
const uint8_t REG_BLOCK_SIZE__TRANSFER_BLOCK_SIZE__SHIFT = 0;

// 006h Block Count Register ビット定義
const uint16_t REG_BLOCK_COUNT__MAX = 0xFFFF;

// 00Ch Transfer Mode Register ビット定義
const uint16_t REG_TRANSFER_MODE__MULTI_BLOCK_SELECT            = 0x1U << 5;
const uint16_t REG_TRANSFER_MODE__DATA_TRANSFER_DIRECTION_READ  = 0x1U << 4;
const uint8_t REG_TRANSFER_MODE__AUTO_CMD_ENABLE__SHIFT = 2;
const uint16_t REG_TRANSFER_MODE__AUTO_CMD_ENABLE__MASK                 = 0x3U << REG_TRANSFER_MODE__AUTO_CMD_ENABLE__SHIFT;
const uint16_t REG_TRANSFER_MODE__AUTO_CMD_ENABLE__AUTO_CMD12_ENABLE    = 0x1U << REG_TRANSFER_MODE__AUTO_CMD_ENABLE__SHIFT;
const uint16_t REG_TRANSFER_MODE__BLOCK_COUNT_ENABLE            = 0x1U << 1;
const uint16_t REG_TRANSFER_MODE__DMA_ENABLE                    = 0x1U << 0;

// 00Eh Command Register ビット定義
const uint8_t REG_COMMAND__COMMAND_INDEX__SHIFT = 8;
const uint16_t REG_COMMAND__COMMAND_INDEX__MASK = 0x3FU << REG_COMMAND__COMMAND_INDEX__SHIFT;
const uint16_t REG_COMMAND__DATA_PRESENT_SELECT                 = 0x1U << 5;
const uint16_t REG_COMMAND__COMMAND_INDEX_CHECK_ENABLE          = 0x1U << 4;
const uint16_t REG_COMMAND__COMMAND_CRC_CHECK_ENABLE            = 0x1U << 3;
const uint8_t REG_COMMAND__RESPONSE_TYPE_SELECT__SHIFT = 0;
const uint16_t REG_COMMAND__RESPONSE_TYPE_SELECT__NO_RESPONSE               = 0x0U << REG_COMMAND__RESPONSE_TYPE_SELECT__SHIFT;
const uint16_t REG_COMMAND__RESPONSE_TYPE_SELECT__RESPONSE_LENGTH_136       = 0x1U << REG_COMMAND__RESPONSE_TYPE_SELECT__SHIFT;
const uint16_t REG_COMMAND__RESPONSE_TYPE_SELECT__RESPONSE_LENGTH_48        = 0x2U << REG_COMMAND__RESPONSE_TYPE_SELECT__SHIFT;
const uint16_t REG_COMMAND__RESPONSE_TYPE_SELECT__RESPONSE_LENGTH_48_BUSY   = 0x3U << REG_COMMAND__RESPONSE_TYPE_SELECT__SHIFT;

// 024h Present State Register ビット定義
const uint32_t REG_PRESENT_STATE__DAT3_LINE_SIGNAL_LEVEL        = 0x1U << 23;
const uint32_t REG_PRESENT_STATE__DAT2_LINE_SIGNAL_LEVEL        = 0x1U << 22;
const uint32_t REG_PRESENT_STATE__DAT1_LINE_SIGNAL_LEVEL        = 0x1U << 21;
const uint32_t REG_PRESENT_STATE__DAT0_LINE_SIGNAL_LEVEL        = 0x1U << 20;
const uint32_t REG_PRESENT_STATE__DAT3_0_LINE_SIGNAL_LEVEL = ( \
    REG_PRESENT_STATE__DAT3_LINE_SIGNAL_LEVEL | \
    REG_PRESENT_STATE__DAT2_LINE_SIGNAL_LEVEL | \
    REG_PRESENT_STATE__DAT1_LINE_SIGNAL_LEVEL | \
    REG_PRESENT_STATE__DAT0_LINE_SIGNAL_LEVEL );
const uint32_t REG_PRESENT_STATE__BUFFER_READ_ENABLE            = 0x1U << 11;
const uint32_t REG_PRESENT_STATE__BUFFER_WRITE_ENABLE           = 0x1U << 10;
const uint32_t REG_PRESENT_STATE__COMMAND_INHIBIT_DAT           = 0x1U << 1;
const uint32_t REG_PRESENT_STATE__COMMAND_INHIBIT_CMD           = 0x1U << 0;

// 02Ch Clock Control Register ビット定義
const uint8_t REG_CLOCK_CONTROL__SDCLK_FREQUENCY_SELECT__SHIFT = 8;
const uint16_t REG_CLOCK_CONTROL__SDCLK_FREQUENCY_SELECT__MASK = 0xFFU << REG_CLOCK_CONTROL__SDCLK_FREQUENCY_SELECT__SHIFT;
const uint8_t REG_CLOCK_CONTROL__UPPER_BITS_OF_SDCLK_FREQUENCY_SELECT__SHIFT = 6;
const uint16_t REG_CLOCK_CONTROL__UPPER_BITS_OF_SDCLK_FREQUENCY_SELECT__MASK = 0x3U << REG_CLOCK_CONTROL__UPPER_BITS_OF_SDCLK_FREQUENCY_SELECT__SHIFT;
const uint16_t REG_CLOCK_CONTROL__CLOCK_GENERATOR_SELECT        = 0x1U << 5;
const uint16_t REG_CLOCK_CONTROL__SD_CLOCK_ENABLE               = 0x1U << 2;
const uint16_t REG_CLOCK_CONTROL__INTERNAL_CLOCK_STABLE         = 0x1U << 1;
const uint16_t REG_CLOCK_CONTROL__INTERNAL_CLOCK_ENABLE         = 0x1U << 0;

// 028h Host Control 1 Register ビット定義
const uint8_t REG_HOST_CONTROL_1__EXTENDED_DATA_TRANSFER_WIDTH  = 0x1U << 5;
const uint8_t REG_HOST_CONTROL_1__HIGH_SPEED_ENABLE             = 0x1U << 2;
const uint8_t REG_HOST_CONTROL_1__DATA_TRANSFER_WIDTH           = 0x1U << 1;
const uint8_t REG_HOST_CONTROL_1__DMA_SELECT__SHIFT = 3;
const uint8_t REG_HOST_CONTROL_1__DMA_SELECT__MASK  = 0x3U << REG_HOST_CONTROL_1__DMA_SELECT__SHIFT;
const uint8_t REG_HOST_CONTROL_1__DMA_SELECT__ADMA2 = 0x2U << REG_HOST_CONTROL_1__DMA_SELECT__SHIFT;
const uint8_t REG_HOST_CONTROL_1__DMA_SELECT__SDMA  = 0x0U << REG_HOST_CONTROL_1__DMA_SELECT__SHIFT;

// 029h Power Control Register ビット定義
const uint8_t REG_POWER_CONTROL__SD_BUS_VOLTAGE_SELECT_FOR_VDD1__SHIFT = 1;
const uint16_t REG_POWER_CONTROL__SD_BUS_VOLTAGE_SELECT_FOR_VDD1__MASK = 0x7U << REG_POWER_CONTROL__SD_BUS_VOLTAGE_SELECT_FOR_VDD1__SHIFT;
const uint16_t REG_POWER_CONTROL__SD_BUS_VOLTAGE_SELECT_FOR_VDD1__3_3V = 0x7U << REG_POWER_CONTROL__SD_BUS_VOLTAGE_SELECT_FOR_VDD1__SHIFT;
const uint16_t REG_POWER_CONTROL__SD_BUS_VOLTAGE_SELECT_FOR_VDD1__3_0V = 0x6U << REG_POWER_CONTROL__SD_BUS_VOLTAGE_SELECT_FOR_VDD1__SHIFT;
const uint16_t REG_POWER_CONTROL__SD_BUS_VOLTAGE_SELECT_FOR_VDD1__1_8V = 0x5U << REG_POWER_CONTROL__SD_BUS_VOLTAGE_SELECT_FOR_VDD1__SHIFT;
const uint16_t REG_POWER_CONTROL__SD_BUS_POWER_FOR_VDD1 = 0x1U << 0;

// 02Eh Timeout Control Register ビット定義
const uint8_t REG_TIMEOUT_CONTROL__DATA_TIMEOUT_COUNTER_VALUE__SHIFT = 0;
const uint8_t REG_TIMEOUT_CONTROL__DATA_TIMEOUT_COUNTER_VALUE__MASK     = 0xFU << REG_TIMEOUT_CONTROL__DATA_TIMEOUT_COUNTER_VALUE__SHIFT;
const uint8_t REG_TIMEOUT_CONTROL__DATA_TIMEOUT_COUNTER_VALUE__MAX      = 0xEU << REG_TIMEOUT_CONTROL__DATA_TIMEOUT_COUNTER_VALUE__SHIFT;

// 02Fh Software Reset Register ビット定義
const uint8_t REG_SOFTWARE_RESET__SOFTWARE_RESET_FOR_DAT        = 0x1U << 2;
const uint8_t REG_SOFTWARE_RESET__SOFTWARE_RESET_FOR_CMD        = 0x1U << 1;
const uint8_t REG_SOFTWARE_RESET__SOFTWARE_RESET_FOR_ALL        = 0x1U << 0;

// 030h/034h Normal Interrupt Status/Enable Register ビット定義
const uint16_t REG_NORMAL_INTERRUPT__ERROR_INTERRUPT            = 0x1U << 15;   // ROC
const uint16_t REG_NORMAL_INTERRUPT__BUFFER_READ_READY          = 0x1U << 5;    // RW1C
const uint16_t REG_NORMAL_INTERRUPT__DMA_INTERRUPT              = 0x1U << 3;    // RW1C
const uint16_t REG_NORMAL_INTERRUPT__TRANSFER_COMPLETE          = 0x1U << 1;    // RW1C
const uint16_t REG_NORMAL_INTERRUPT__COMMAND_COMPLETE           = 0x1U << 0;    // RW1C
#if (defined(NN_DETAIL_SDMMC_ADMA2_ENABLE))
    const uint16_t REG_NORMAL_INTERRUPT__ISSUE_COMMAND__MASK = ( \
        REG_NORMAL_INTERRUPT__TRANSFER_COMPLETE | \
        REG_NORMAL_INTERRUPT__COMMAND_COMPLETE );
#else   // SDMA
    const uint16_t REG_NORMAL_INTERRUPT__ISSUE_COMMAND__MASK = ( \
        REG_NORMAL_INTERRUPT__DMA_INTERRUPT | \
        REG_NORMAL_INTERRUPT__TRANSFER_COMPLETE | \
        REG_NORMAL_INTERRUPT__COMMAND_COMPLETE );
#endif

// 032h/038h Error Interrupt Status/Enable Register ビット定義
const uint16_t REG_ERROR_INTERRUPT__ADMA_ERROR                  = 0x1U << 9;    // RW1C
const uint16_t REG_ERROR_INTERRUPT__AUTO_CMD_ERROR              = 0x1U << 8;    // RW1C
const uint16_t REG_ERROR_INTERRUPT__DATA_END_BIT_ERROR          = 0x1U << 6;    // RW1C
const uint16_t REG_ERROR_INTERRUPT__DATA_CRC_ERROR              = 0x1U << 5;    // RW1C
const uint16_t REG_ERROR_INTERRUPT__DATA_TIMEOUT_ERROR          = 0x1U << 4;    // RW1C
const uint16_t REG_ERROR_INTERRUPT__COMMAND_INDEX_ERROR         = 0x1U << 3;    // RW1C
const uint16_t REG_ERROR_INTERRUPT__COMMAND_END_BIT_ERROR       = 0x1U << 2;    // RW1C
const uint16_t REG_ERROR_INTERRUPT__COMMAND_CRC_ERROR           = 0x1U << 1;    // RW1C
const uint16_t REG_ERROR_INTERRUPT__COMMAND_TIMEOUT_ERROR       = 0x1U << 0;    // RW1C
#if (defined(NN_DETAIL_SDMMC_ADMA2_ENABLE))
    const uint16_t REG_ERROR_INTERRUPT__ISSUE_COMMAND__MASK = ( \
        REG_ERROR_INTERRUPT__ADMA_ERROR | \
        REG_ERROR_INTERRUPT__AUTO_CMD_ERROR | \
        REG_ERROR_INTERRUPT__DATA_END_BIT_ERROR | \
        REG_ERROR_INTERRUPT__DATA_CRC_ERROR | \
        REG_ERROR_INTERRUPT__DATA_TIMEOUT_ERROR | \
        REG_ERROR_INTERRUPT__COMMAND_INDEX_ERROR | \
        REG_ERROR_INTERRUPT__COMMAND_END_BIT_ERROR | \
        REG_ERROR_INTERRUPT__COMMAND_CRC_ERROR | \
        REG_ERROR_INTERRUPT__COMMAND_TIMEOUT_ERROR );
#else   // SDMA
    const uint16_t REG_ERROR_INTERRUPT__ISSUE_COMMAND__MASK = ( \
        REG_ERROR_INTERRUPT__AUTO_CMD_ERROR | \
        REG_ERROR_INTERRUPT__DATA_END_BIT_ERROR | \
        REG_ERROR_INTERRUPT__DATA_CRC_ERROR | \
        REG_ERROR_INTERRUPT__DATA_TIMEOUT_ERROR | \
        REG_ERROR_INTERRUPT__COMMAND_INDEX_ERROR | \
        REG_ERROR_INTERRUPT__COMMAND_END_BIT_ERROR | \
        REG_ERROR_INTERRUPT__COMMAND_CRC_ERROR | \
        REG_ERROR_INTERRUPT__COMMAND_TIMEOUT_ERROR );
#endif

// 03Ch Auto CMD Error Status Register ビット定義
const uint16_t REG_AUTO_CMD_ERROR__COMMAND_NOT_ISSUED           = 0x1U << 7;    // ROC
const uint16_t REG_AUTO_CMD_ERROR__AUTO_CMD_INDEX_ERROR         = 0x1U << 4;    // ROC
const uint16_t REG_AUTO_CMD_ERROR__AUTO_CMD_END_BIT_ERROR       = 0x1U << 3;    // ROC
const uint16_t REG_AUTO_CMD_ERROR__AUTO_CMD_CRC_ERROR           = 0x1U << 2;    // ROC
const uint16_t REG_AUTO_CMD_ERROR__AUTO_CMD_TIMEOUT_ERROR       = 0x1U << 1;    // ROC
const uint16_t REG_AUTO_CMD_ERROR__AUTO_CMD_NOT_EXECUTED        = 0x1U << 0;    // ROC

// 03Eh Host Control 2 Register ビット定義
const uint16_t REG_HOST_CONTROL_2__PRESET_VALUE_ENABLE          = 0x1U << 15;
const uint16_t REG_HOST_CONTROL_2__64BIT_ADDRESSING_ENABLE      = 0x1U << 13;
const uint16_t REG_HOST_CONTROL_2__HOST_VERSION_4_00_ENABLE     = 0x1U << 12;
const uint16_t REG_HOST_CONTROL_2__SAMPLING_CLOCK_SELECT        = 0x1U << 7;
const uint16_t REG_HOST_CONTROL_2__EXECUTE_TUNING               = 0x1U << 6;
const uint16_t REG_HOST_CONTROL_2__1_8V_SIGNALING_ENABLE        = 0x1U << 3;
const uint8_t REG_HOST_CONTROL_2__UHS_MODE_SELECT__SHIFT = 0;
const uint16_t REG_HOST_CONTROL_2__UHS_MODE_SELECT__MASK    = 0x7U << REG_HOST_CONTROL_2__UHS_MODE_SELECT__SHIFT;
const uint16_t REG_HOST_CONTROL_2__UHS_MODE_SELECT__SDR12   = 0x0U << REG_HOST_CONTROL_2__UHS_MODE_SELECT__SHIFT;
const uint16_t REG_HOST_CONTROL_2__UHS_MODE_SELECT__SDR25   = 0x1U << REG_HOST_CONTROL_2__UHS_MODE_SELECT__SHIFT;
const uint16_t REG_HOST_CONTROL_2__UHS_MODE_SELECT__SDR50   = 0x2U << REG_HOST_CONTROL_2__UHS_MODE_SELECT__SHIFT;
const uint16_t REG_HOST_CONTROL_2__UHS_MODE_SELECT__SDR104  = 0x3U << REG_HOST_CONTROL_2__UHS_MODE_SELECT__SHIFT;

// 040h Capabilities Register ビット定義
const uint32_t REG_CAPABILITIES__64BIT_SYSTEM_ADDRESS_SUPPORT = 0x1U << 28;

// ADMA2 Descriptor アライン 64bit
const size_t ADma2DescriptorsAlignment = sizeof(uint64_t);

} // namespace detail {
}} // namespace nn { namespace sdmmc1 {
