﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace sdmmc1 {
namespace detail {

namespace ClockResetController {

    enum Module
    {
        Module_Sdmmc1,
        Module_Sdmmc2,
        Module_Sdmmc3,
        Module_Sdmmc4,
    };

    void Initialize() NN_NOEXCEPT;
    bool IsAvailable(Module module) NN_NOEXCEPT;
    void SetClockFrequencyKHz(uint32_t* pOutActualClockFrequencyKHz, Module module, uint32_t targetClockFrequencyKHz) NN_NOEXCEPT;
    void Reset(Module module) NN_NOEXCEPT;

} // namespace ClockResetController {

} // namespace detail {
}} // namespace nn { namespace sdmmc1 {
