﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include "../../include/nn/i2c/driver/i2c.h"

#include "i2c_TargetSpec.h"

namespace {

// DeviceSettings をサーチして device と対応する index を返す関数
int SearchIndex(nn::i2c::I2cDevice device) NN_NOEXCEPT
{
    for( int i = 0; i < nn::i2c::driver::detail::DeviceSettingsLength; i++ )
    {
        if( device == nn::i2c::driver::detail::DeviceSettings[i].device )
        {
            return i;
        }
    }
    // 該当するデバイスが見つからなければ不正なデバイス。ハンドリングできないので ABORT
    NN_ABORT("Device Not Found\n");
}

}

namespace nn {
namespace i2c {
namespace driver {
namespace detail {

int GetBusIdx( I2cDevice device ) NN_NOEXCEPT
{
    return DeviceSettings[SearchIndex(device)].busIdx;
}

nn::Bit16 GetSlaveAddress( I2cDevice device ) NN_NOEXCEPT
{
    return DeviceSettings[SearchIndex(device)].slaveAddress;
}

AddressingMode GetAddressingMode( I2cDevice device ) NN_NOEXCEPT
{
    return DeviceSettings[SearchIndex(device)].addressingMode;
}

SpeedMode GetSpeedMode( I2cDevice device ) NN_NOEXCEPT
{
    return DeviceSettings[SearchIndex(device)].speedMode;
}

} // detail
} // driver
} // i2c
} // nn
