﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_CpuUse_Setup.h"
#include <string>
#include <nn/fs.h>
#include <nn/fs/fs_Debug.h>
#include <nn/nn_Assert.h>


void CpuUseTestFixture::SetUp()
{
    // all the parameters we are looking for
    const char cpu_core[] = "--cpu_core";
    const char busy_ms[] = "--busy_milliseconds";
    const char thread_priority[] = "--thread_priority";
    const char thread_duty_cycle[] = "--thread_duty_cycle";

    // get all the input parameter values
    char** argv = nnt::GetHostArgv();
    // subtract 1 param to exclude the --gtest one
    int argc = nnt::GetHostArgc() - 1;

    for (int i = 1; i < argc; i++)
    {
        if (strncmp(argv[i], cpu_core, strlen(cpu_core)) == 0)
        {
            NN_LOG("argv %i    : %s\n", i, argv[i]);
            threadArgs.cpu_core = atoi(&(argv[i][strlen(cpu_core) + 1]));
        }
        else if (strncmp(argv[i], busy_ms, strlen(busy_ms)) == 0)
        {
            NN_LOG("argv %i    : %s\n", i, argv[i]);
            threadArgs.busy_wait_ms = atoi(&(argv[i][strlen(busy_ms) + 1]));
        }
        else if (strncmp(argv[i], thread_priority, strlen(thread_priority)) == 0)
        {
            NN_LOG("argv %i    : %s\n", i, argv[i]);
            threadArgs.thread_priority = atoi(&(argv[i][strlen(thread_priority) + 1]));
        }
        else if (strncmp(argv[i], thread_duty_cycle, strlen(thread_duty_cycle)) == 0)
        {
            NN_LOG("argv %i    : %s\n", i, argv[i]);
            threadArgs.thread_duty_cycle_percent = atoi(&(argv[i][strlen(thread_duty_cycle) + 1]));
        }
        else
        {
            NN_LOG("argv %s is not recognized\n", argv[i]);
        }
    }

    // mount the file system
    // auto result = nn::fs::MountSaveDataForDebug(mountName);
    auto result = nn::fs::MountSaveDataForDebug(mountName);
    NN_ASSERT(result.IsSuccess(), "[ERROR] failed to nn::fs::MountSaveDataForDebug");
}


void CpuUseTestFixture::TearDown()
{
    nn::fs::Unmount(mountName);
}


// check if a signal file exists
bool CpuUseTestFixture::IsSignalFileExists()
{
    nn::Result result;

    nn::fs::DirectoryEntryType type;
    result = nn::fs::GetEntryType(&type, saveFilePath);
    return result.IsSuccess();
}


// create the signal file
bool CpuUseTestFixture::CreateSignalFile()
{
    nn::Result result;

    // create file if not exist
    nn::fs::DirectoryEntryType type;
    result = nn::fs::GetEntryType(&type, saveFilePath);
    if (nn::fs::ResultPathNotFound().Includes(result))
    {
        result = nn::fs::CreateFile(saveFilePath, 0);
        NN_ASSERT(result.IsSuccess(), "CreateFile failed\n");
    }

    return result.IsSuccess();
}


// delete the signal file
bool CpuUseTestFixture::DeleteSignalFile()
{
    nn::Result result;

    result = nn::fs::DeleteFile(saveFilePath);
    return result.IsSuccess();
}
