﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/spy/audio/spy_AudioSpyModule.h>

extern bool g_ExecuteTest;

TEST(IncludeTest, spy_AudioSpyModule_h)
{
    if (g_ExecuteTest)
    {
        nn::spy::audio::AudioSpyModule audioSpyModule;

        nn::spy::SpyController spyController;
        nn::audio::AudioRendererParameter parameter;

        nn::spy::audio::AudioSpyModule::InitializeArg initializeArg;
        initializeArg.pAudioRendererParameter = &parameter;

        (void)nn::spy::audio::AudioSpyModule::GetRequiredMemorySize(initializeArg);

        (void)audioSpyModule.Initialize(
            initializeArg,
            nullptr /*buffer*/,
            0 /*bufferSize*/);

        audioSpyModule.Finalize();

        (void)audioSpyModule.IsInitialized();

        audioSpyModule.PushPerformanceMetrics(
            nullptr /*performanceFrameBuffer*/,
            0 /*performanceFrameBufferSize*/);

        audioSpyModule.PushPerformanceMetrics(
            nullptr /*performanceFrameBuffer*/,
            0 /*performanceFrameBufferSize*/,
            nn::os::Tick(0) /*tick*/);

        audioSpyModule.PushWaveform(
            nullptr /*buffer*/,
            0 /*bufferSize*/,
            nn::os::Tick(0) /*tick*/);
    }

    EXPECT_TRUE(true);
}
