﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/spy/atk/spy_AtkSpyModule.h>

extern bool g_ExecuteTest;

TEST(IncludeTest, spy_AtkSpyModule_h)
{
    if (g_ExecuteTest)
    {
        nn::spy::atk::AtkSpyModule atkSpyModule;

        nn::spy::SpyController spyController;
        nn::spy::atk::AtkSpyModule::InitializeArg initializeArg;
        nn::atk::SoundArchivePlayer* pSoundArchivePlayer = nullptr;
        nn::atk::SoundHeap soundHeap;

        (void)nn::spy::atk::AtkSpyModule::GetRequiredMemorySize(initializeArg);

        atkSpyModule.Initialize(initializeArg, nullptr, 0);

        atkSpyModule.Finalize();

        atkSpyModule.IsInitialized();

        atkSpyModule.IsPerformanceMetricsInitialized();

        atkSpyModule.IsWaveformInitialized();

        atkSpyModule.IsAtkProfilesInitialized();

        atkSpyModule.IsLogEnabled();

        atkSpyModule.SetLogEnabled(false);

        atkSpyModule.IsSoundStateEnabled();

        atkSpyModule.SetSoundStateEnabled(false);

        atkSpyModule.IsPerformanceMetricsEnabled();

        atkSpyModule.SetPerformanceMetricsEnabled(false);

        atkSpyModule.IsWaveformEnabled();

        atkSpyModule.SetWaveformEnabled(false);

        atkSpyModule.IsAtkProfilesEnabled();

        atkSpyModule.SetAtkProfilesEnabled(false);

        atkSpyModule.IsSoundArchivePlayerInfoEnabled();

        atkSpyModule.SetSoundArchivePlayerInfoEnabled(false);

        atkSpyModule.IsSoundSystemInfoEnabled();

        atkSpyModule.SetSoundSystemInfoEnabled(false);

        atkSpyModule.IsSoundHeapInfoEnabled();

        atkSpyModule.SetSoundHeapInfoEnabled(false);

        atkSpyModule.IsStreamSoundInfoEnabled();

        atkSpyModule.SetStreamSoundInfoEnabled(false);

        atkSpyModule.PushSoundState(*pSoundArchivePlayer);

        atkSpyModule.PushPerformanceMetrics();

        atkSpyModule.PushWaveform(nullptr /* buffer */, 0 /* bufferSize */, nn::os::Tick(0));

        atkSpyModule.PushAtkProfiles();

        atkSpyModule.PushAtkProfiles(*pSoundArchivePlayer);

        atkSpyModule.PushSoundArchivePlayerInfo(*pSoundArchivePlayer);

        atkSpyModule.PushSoundSystemInfo();

        atkSpyModule.PushSoundHeapInfo(soundHeap);

        atkSpyModule.PushSequenceVariable(*pSoundArchivePlayer);

        atkSpyModule.PushStreamSoundInfo(*pSoundArchivePlayer);
    }

    EXPECT_TRUE(true);
}
