﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;

namespace ToolVersionUpdater
{
    /// <summary>
    /// デフォルトのデータテンプレートセレクタです。
    /// </summary>
    public class DefaultTemplateSelector : DataTemplateSelector
    {
        /// <summary>
        /// 適切なデータテンプレートを選択して取得します。
        /// </summary>
        /// <param name="item">入力アイテムです。</param>
        /// <param name="container">コンテナです。</param>
        /// <returns>データテンプレートを返します。</returns>
        public override DataTemplate SelectTemplate(object item, DependencyObject container)
        {
            if (item is ParamInt)
            {
                throw new NotImplementedException();
            }
            else if (item is ParamFloat)
            {
                throw new NotImplementedException();
            }
            else if (item is ParamBool)
            {
                return new DataTemplate
                {
                    VisualTree = new FrameworkElementFactory(typeof(Views.ParamBoolUITypeView))
                };
            }
            else if (item is ParamString)
            {
                if ((item as ParamString).UIType == UIType.FilePath.ToString())
                {
                    return new DataTemplate
                    {
                        VisualTree = new FrameworkElementFactory(typeof(Views.ParamPathUITypeView))
                    };
                }
                else if ((item as ParamString).UIType == UIType.DirectoryPath.ToString())
                {
                    return new DataTemplate
                    {
                        VisualTree = new FrameworkElementFactory(typeof(Views.ParamDirectoryPathUITypeView))
                    };
                }
                else
                {
                    return new DataTemplate
                    {
                        VisualTree = new FrameworkElementFactory(typeof(Views.ParamStringUITypeView))
                    };
                }
            }

            return null;
        }
    }
}
