﻿using Nintendo.ToolFoundation.Collections;
using Reactive.Bindings;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ToolVersionUpdater
{
    public enum ParamType
    {
        Int,
        Bool,
        Float,
        String,
    }

    public interface IParam
    {
        string ID { get; }
        string Name { get; }
        ParamType ParamType { get; }
        string UIType { get; }
        string UIParam { get; }
        bool IsReadOnly { get; }
    }

    public abstract class BaseParam
    {
        public string ID { get; set; } = string.Empty;
        public string Name { get; set; } = string.Empty;
        public string UIType { get; set; } = string.Empty;
        public string UIParam { get; set; } = string.Empty;
        public bool IsReadOnly { get; set; } = false;
    }

    public class ParamInt : BaseParam, IParam
    {
        public ParamType ParamType { get { return ParamType.Int; } }
        public ReactiveProperty<int> Value { get; } = new ReactiveProperty<int>(0);
    }

    public class ParamFloat : BaseParam, IParam
    {
        public ParamType ParamType { get { return ParamType.Float; } }
        public ReactiveProperty<float> Value { get; } = new ReactiveProperty<float>(0.0f);
    }

    public class ParamBool : BaseParam, IParam
    {
        public ParamType ParamType { get { return ParamType.Bool; } }
        public ReactiveProperty<bool> Value { get; } = new ReactiveProperty<bool>(false);
    }

    public class ParamString : BaseParam, IParam
    {
        public ParamType ParamType { get { return ParamType.String; } }
        public ReactiveProperty<string> Value { get; } = new ReactiveProperty<string>(string.Empty);
    }
}
