﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ToolVersionChecker
{
    public class Utility
    {
        private static string EncodeStringToDefault(string log, Encoding sourceEncoding)
        {
            byte[] logBytes = sourceEncoding.GetBytes(log);
            byte[] encodedBytes = Encoding.Convert(sourceEncoding, Encoding.Default, logBytes);
            string encodedLog = Encoding.Default.GetString(encodedBytes);
            return encodedLog;
        }

        public static bool HasSubstrings(string targetString, string[] substrings)
        {
            if (substrings == null)
            {
                return false;
            }

            foreach (var substring in substrings)
            {
                if (!string.IsNullOrEmpty(substring) && targetString.Contains(substring))
                {
                    return true;
                }
            }

            return false;
        }
        public static void ExecuteCommand(
            out string standardOut,
            out string standardError,
            string command,
            string args,
            Encoding outputEncoding)
        {
            ExecuteCommand(
                out standardOut, out standardError,
                command, args, System.IO.Directory.GetCurrentDirectory(), outputEncoding);
        }
        public static void ExecuteCommand(
            string command,
            string args,
            string workingDirectory)
        {
            ExecuteCommand(
                command, args, workingDirectory, Encoding.Default);
        }

        public static void ExecuteCommand(
            out string standardOut,
            out string standardError,
            string command,
            string args,
            string workingDirectory,
            Encoding outputEncoding)
        {
            System.Diagnostics.Process process = new System.Diagnostics.Process();
            process.StartInfo.FileName = command;
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardOutput = true;
            process.StartInfo.RedirectStandardError = true;
            process.StartInfo.RedirectStandardInput = false;
            process.StartInfo.CreateNoWindow = true;
            process.StartInfo.Arguments = args;
            process.StartInfo.WorkingDirectory = workingDirectory;
            process.StartInfo.StandardOutputEncoding = outputEncoding;
            process.StartInfo.StandardErrorEncoding = outputEncoding;

            process.Start();

            //出力を読み取る
            string tempStandardOut = process.StandardOutput.ReadToEnd();
            string tempStandardError = process.StandardError.ReadToEnd();

            process.WaitForExit();
            process.Close();

            standardOut = EncodeStringToDefault(tempStandardOut, outputEncoding);
            standardError = EncodeStringToDefault(tempStandardError, outputEncoding);
        }

        public static void ExecuteCommand(
            string command,
            string args,
            string workingDirectory,
            Encoding outputEncoding)
        {
            System.Diagnostics.Process process = new System.Diagnostics.Process();
            process.StartInfo.FileName = command;
            process.StartInfo.UseShellExecute = true;
            process.StartInfo.RedirectStandardOutput = false;
            process.StartInfo.RedirectStandardError = false;
            process.StartInfo.RedirectStandardInput = false;
            process.StartInfo.CreateNoWindow = false;
            process.StartInfo.Arguments = args;
            process.StartInfo.WorkingDirectory = workingDirectory;

            process.Start();
            process.WaitForExit();
            process.Close();
        }

        public static void ConvertToGitLogs(out GitLog[] outLogs, string gitOnelineLog, bool skipsMergeLog)
        {
            List<GitLog> logs = new List<GitLog>();
            var lines = gitOnelineLog.Split('\n');
            foreach (var line in lines)
            {
                var logElements = line.Split(' ');
                if (logElements == null || logElements.Length < 2)
                {
                    continue;
                }

                string hash = logElements[0];
                if (skipsMergeLog && logElements[1].Substring(0, 5) == "Merge")
                {
                    continue;
                }

                var logBodyElements = logElements[1].Split(')');
                if (logBodyElements[0].Length < 2)
                {
                    continue;
                }

                string taskNumber = logBodyElements[0].Substring(1);
                string taskUrl = "http://spdlybra.nintendo.co.jp/jira/browse/" + taskNumber;
                string message = string.Empty;
                for (int i = 1; i < logElements.Length; ++i)
                {
                    message += logElements[i] + " ";
                }

                GitLog existingLog = logs.FirstOrDefault(x => x.TaskUrl == taskUrl);
                if (existingLog != null)
                {
                    existingLog.Message += "\n" + message;
                }
                else
                {
                    logs.Add(new GitLog() { CommitHash = hash, TaskUrl = taskUrl, Message = message });
                }
            }

            outLogs = logs.ToArray();
        }
    }
}
