﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.UnitTest
{
    public static class AssertUtil
    {
        public static void AssertAreDeepEqualByPublicProperties(object x, object y)
        {
            Assert.IsTrue(AreDeepEqualByPublicProperties(x, y));
        }

        private static bool AreDeepEqualByPublicProperties(object x, object y)
        {
            if (object.ReferenceEquals(x, y))
            {
                return true;
            }
            if (x == null || y == null)
            {
                return false;
            }
            if (x.GetType() != y.GetType())
            {
                return false;
            }
            // IEquatable<T> を実装しているなら、信じて Equals を呼ぶ
            if (x.GetType().GetInterfaces().Contains(typeof(IEquatable<>).MakeGenericType(x.GetType())))
            {
                return x.Equals(y);
            }
            // IEnumerable を実装しているなら、要素ごとの比較
            if (x is System.Collections.IEnumerable)
            {
                var xs = Enumerate((x as System.Collections.IEnumerable));
                var ys = Enumerate((y as System.Collections.IEnumerable));
                return xs.Zip(ys, (a, b) => AreDeepEqualByPublicProperties(a, b)).All(_ => _);
            }

            return x.GetType().GetProperties(BindingFlags.Public | BindingFlags.Instance).All(
                fi => AreDeepEqualByPublicProperties(fi.GetValue(x), fi.GetValue(y)));
        }

        private static IEnumerable<object> Enumerate(System.Collections.IEnumerable e)
        {
            foreach (object o in e)
            {
                yield return o;
            }
        }
    }
}
