﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EnvDTE;
using Microsoft.VisualStudio.Shell.Interop;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.NintendoSdkVsExtension.VcAccessors;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace Nintendo.NintendoSdkVsExtension.UnitTest.VcAccessorsTest
{
    [TestClass]
    [DeploymentItem(InIdeTestConstants.VsVersionSpecificTestDataSourceDirectory + @"Project.Generic", @"Data\Project.Generic")]
    public class VcAccessorUtilTest
    {
        public TestContext TestContext { get; set; }
        private static XDocument projectXml;

        [ClassInitialize]
        public static void ClassInitialize(TestContext context)
        {
            projectXml = XDocument.Load(@"Data\Project.Generic\Project\Project.vcxproj");
        }

        [ClassCleanup]
        public static void ClassCleanup()
        {
            projectXml = null;
        }

        [TestInitialize]
        public void TestInitialize()
        {
            VsTestUtil.EnsureOpenSolution(@"Data\Project.Generic\Project.sln");
        }

        private static IVsHierarchy GetTargetHierarchy()
        {
            return VsTestUtil.GetHierarchyOfName(@"Project\Project.vcxproj");
        }

        [TestMethod]
        [HostType("VS IDE")]
        public void TestProjectAccessor()
        {
            var h = GetTargetHierarchy();
            var a = new VcProjectAccessor(h);

            // TODO: VcProjectAccessor のテスト
        }
    }
}
