﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

namespace {
    // ROMのマウント名定義
    const char* ROM_ROOT_NAME = "Contents";
} // namespace

struct MetaInfo
{
    std::string contentType;
    std::string id;
    std::string version;
    std::string releaseVersion;
    std::string privateVersion;
    std::string createdTime;

    void SetInitParam() NN_NOEXCEPT;
    void ConvertVersion() NN_NOEXCEPT;
};

class RomInfoUtil
{
public:
    RomInfoUtil() NN_NOEXCEPT {}
    ~RomInfoUtil() NN_NOEXCEPT {}

    static void ReadExpectedHashValue(char outVal[]) NN_NOEXCEPT;
    static void GetRomDataHashValue(char outVal[]) NN_NOEXCEPT;

    static void GetMetaInfoData(MetaInfo& outMetaInfo) NN_NOEXCEPT;

private:
    static void ParseMetaInfoList(const std::string& inMetaFileData, MetaInfo& outMetaInfo) NN_NOEXCEPT;
};
