﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <string>

namespace {
    const size_t HASH_STRING_SIZE = 40;
} // namespace

class CommonUtil
{
public:
    CommonUtil() NN_NOEXCEPT{}
    ~CommonUtil() NN_NOEXCEPT{}

    static bool IsExistExpectedHashFile(const std::string& inTargetMountName) NN_NOEXCEPT;
    static nn::Result ReadExpectedHashValue(char outVal[], const std::string& inTargetMountName) NN_NOEXCEPT;
    static nn::Result GetFileDataHashValue(char outVal[], const std::string& inTargetFilePath) NN_NOEXCEPT;
};
