﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// NintendoSDK のヘッダファイルをインクルードする前に、NN_GFX_UTIL_DEBUGFONT_USE_DEFAULT_LOCALE_CHARSET マクロを
// 定義することで、DebugFont::Print() の入力文字コードを Windows のロケールのデフォルト
// (日本語の場合、CP932)に変更できます。
#define NN_GFX_UTIL_DEBUGFONT_USE_DEFAULT_LOCALE_CHARSET

#include <nn/nn_Common.h>
#include <nn/hid/hid_DebugPad.h>
#include <nn/hid/hid_TouchScreen.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

enum class NextAction : nn::Bit8
{
    None,
    MetaInfo,
    RomHash,
    HtmlDoc,
    AocInfo,
    OperationEnv,
    Account,
    ECommerce,
    AbortDebug,
    Network,
    Bcat,
    Mii,
    Album,
    MultiProgram,
    EcOcsi,
    EcCatalog,
    SaveData,
    Headline,
    Exit
};

struct LaunchStorageInfo
{
    std::string launch;
    std::string patch;

    // ひとまず初期値は None にしておく
    LaunchStorageInfo() :
        launch("None"), patch("None") {}
};

class Scene
{
    NN_DISALLOW_COPY(Scene);

public:
    Scene() NN_NOEXCEPT {}
    virtual ~Scene() NN_NOEXCEPT{}

    virtual void Setup(nn::gfx::util::DebugFontTextWriter* writer, const nn::hid::TouchScreenState<1>& inTouchState, NextAction ownPage) NN_NOEXCEPT = 0;
    virtual void ResetState() NN_NOEXCEPT = 0;
    virtual void HandleNPad() NN_NOEXCEPT = 0;
    virtual void HandleTouchScreen(const nn::hid::TouchScreenState<1>& state) NN_NOEXCEPT = 0;
    virtual NextAction Process() NN_NOEXCEPT = 0;
    virtual void UpdateContents() NN_NOEXCEPT {}
    virtual void DrawDebugText(nn::gfx::util::DebugFontTextWriter* inWriter) NN_NOEXCEPT = 0;

    virtual void SetLaunchStorageInfo(LaunchStorageInfo&& inStorageInfo) NN_NOEXCEPT = 0;

    virtual void EnterScene() NN_NOEXCEPT = 0;
    virtual void LeaveScene() NN_NOEXCEPT = 0;
};
