﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TestAppSimple_SceneCommon.h"

#include "TestAppSimple_Hash.h"

class RomHashScene : public SceneCommon
{
    NN_DISALLOW_COPY(RomHashScene);

public:
    RomHashScene() NN_NOEXCEPT;
    virtual ~RomHashScene() NN_NOEXCEPT NN_OVERRIDE {}

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    void DrawHashInfo(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;

private:
    enum State
    {
        State_None,
        State_CalcHash,
        State_CalcProcessing,
        State_CalcEnd,
    };

    State m_State;

    bool m_IsGetHashVal;
    bool m_IsHashMatch;
    bool m_IsExistDummyFile;

    char m_HashVal[Hash::Sha1MaxStrSize + 1];
    int64_t m_FileSize;

    Hash m_Hash;
    int m_CalcCount;
    int m_Progress;

    SceneCommon::TouchRange m_CalculateRange;
};
