﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TestAppSimple_SceneCommon.h"

class MultiProgramScene : public SceneCommon
{
    NN_DISALLOW_COPY(MultiProgramScene);

public:
    MultiProgramScene() NN_NOEXCEPT;
    virtual ~MultiProgramScene() NN_NOEXCEPT NN_OVERRIDE {}

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    enum State
    {
        State_None,
        State_JumpReady,
        State_ChangeIndexNumber,
        State_InputLaunchParam,
        State_LaunchJumpFunction,
    };

    State m_State;

    int m_PreviousProgramIndexNum;
    std::string m_InputIndexNumber;
    nn::Result m_LastJumpFunctionResult;
    std::string m_InputLaunchParam;

    SceneCommon::RangePackage m_ChangeIndexNumber;
    SceneCommon::RangePackage m_JumpToIndexNumber;
    SceneCommon::RangePackage m_InputLaunchParamRange;

    WarningView m_WarningView;
    // メッセージ中で変動する箇所の配列インデックス
    size_t m_IndexNumMsgIdx;

private:
    std::string GetInputIndexNumber() NN_NOEXCEPT;
    std::string GetInputLaunchParam() NN_NOEXCEPT;
};
