﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TestAppSimple_SceneCommon.h"

class EcServiceSceneCommon : public SceneCommon
{
    NN_DISALLOW_COPY(EcServiceSceneCommon);

public:
    static void UpdaetAccount() NN_NOEXCEPT;

protected:
    EcServiceSceneCommon() NN_NOEXCEPT;
    virtual ~EcServiceSceneCommon() NN_NOEXCEPT NN_OVERRIDE;

    // 型定義
    struct Label
    {
        Position base;
        float xBracketL;
        float xRangeLabel;
        float xBracketR;
        std::string prefix;
        TouchRange range;
    };

    // 定数定義
    const Position BaseLine             = Position(40.0f, 75.0f);

    const int LineCountMax = 10;
    const float Indent = 40.0f;
    const float NewLine = 33.0f;
    const float Margin = 20.0f;

    const char* BracketLeft = "[ ";
    const char* BracketRight = " ]";

    // 共通ラベル
    Label m_PageLabel;
    Label m_AccountLabel;

    void SetEcServiceHeader(Position* line, const char* name) NN_NOEXCEPT;
    void DrawEcServiceHeader(Position* line, nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;
    void WriteLabel(nn::gfx::util::DebugFontTextWriter* writer, Label* label) NN_NOEXCEPT;
};
