﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account.h>
#include <nn/err.h>

#include "TestAppSimple_EcServiceTypes.h"
#include "TestAppSimple_WorkContractor.h"

class UserSelector;

// 消費型サービスアイテムの権利購入
class EcOcsiRightPurchaser : public Work
{
public:
    EcOcsiRightPurchaser() NN_NOEXCEPT;
    virtual ~EcOcsiRightPurchaser() NN_NOEXCEPT NN_OVERRIDE;

    void Prepare(const nn::account::NetworkServiceAccountId& nsaId) NN_NOEXCEPT;

protected:
    nn::account::NetworkServiceAccountId m_NsaId;
    char m_JsonBuffer[1024];
    char m_UrlBuffer[128];
    char m_HeaerBuffer[128];

    virtual bool Exeute() NN_NOEXCEPT NN_OVERRIDE;
    bool Purchase() NN_NOEXCEPT;
};

// 消費型サービスアイテムの権利照会・権利消費
class EcOcsiRightConsumer : public Work
{
public:
    EcOcsiRightConsumer() NN_NOEXCEPT;
    virtual ~EcOcsiRightConsumer() NN_NOEXCEPT NN_OVERRIDE;

    void PrepareToInquire(UserSelector* pUserSelector) NN_NOEXCEPT;
    void PrepareToInquire(const nn::account::Uid& uid) NN_NOEXCEPT;
    void PrepareToConsume(const nn::account::Uid& uid, const EcOcsiRightList& list) NN_NOEXCEPT;

    const nn::err::ErrorCode& GetErrorCode() const NN_NOEXCEPT;
    void UpdateRights(EcOcsiRightList* list) const NN_NOEXCEPT;

protected:
    enum Request
    {
        Request_None,
        Request_Inquire,
        Request_Consume,
    };

    Request m_Request;
    UserSelector* m_pUserSelector;
    nn::account::Uid m_Uid;
    int m_RightCount;
    nn::ec::ConsumableServiceItemRightData m_Rights[EcOcsiRightCountMax];
    nn::err::ErrorCode m_ErrorCode;

    void Prepare(Request request, const nn::account::Uid& uid, UserSelector* pUserSelector) NN_NOEXCEPT;

    void UpdateInquireRights(EcOcsiRightList* list) const NN_NOEXCEPT;
    void UpdateConsumeRights(EcOcsiRightList* list) const NN_NOEXCEPT;

    virtual bool Exeute() NN_NOEXCEPT NN_OVERRIDE;
    nn::Result Inquire() NN_NOEXCEPT;
    nn::Result Consume() NN_NOEXCEPT;
};
