﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/aoc.h>

#include "TestAppSimple_SceneCommon.h"
#include "TestAppSimple_Hash.h"

class AocInfoScene : public SceneCommon
{
    NN_DISALLOW_COPY(AocInfoScene);

public:
    NN_IMPLICIT AocInfoScene() NN_NOEXCEPT;
    virtual ~AocInfoScene() NN_NOEXCEPT NN_OVERRIDE;

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    // 各プロパティが持つ状態定義
    enum PropertyState
    {
        PropertyState_NotCalcHash,
        PropertyState_CalcProcessing,
        PropertyState_HashOKEnd,
        PropertyState_HashNGEnd,
    };

    // 各Aocごとのプロパティ構造体定義
    struct AocInfoProperty
    {
        nn::aoc::AddOnContentIndex index;
        bool isDefaultData;
        PropertyState state;
        // SHA1のハッシュ値文字列
        std::string hashVal;
        // 32bitのバージョン値 (10進数で持つ)
        std::string verVal;
        // ReleaseVersion値 (16進数で持つ)
        std::string rVerVal;
        // PrivateVersion値 (16進数で持つ)
        std::string pVerVal;
        std::string prefixStr;
        std::string displayStr;

        AocInfoProperty()
            : isDefaultData(false), state(PropertyState_NotCalcHash) {}
    };

private:
    void ReadAocInfoList() NN_NOEXCEPT;
    void ReadAocPropertyInfo(AocInfoProperty* inoutProperty) NN_NOEXCEPT;
    std::string ReadAocRecordFile(const char* inReadFilePath) NN_NOEXCEPT;
    void ResetAocRangeList() NN_NOEXCEPT;
    void DrawAocList(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;
    void DrawAocItemDetail(nn::gfx::util::DebugFontTextWriter* writer, AocInfoProperty* aoc, int yPoint) NN_NOEXCEPT;
    void DrawReloadButton(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;

    void ReloadAocInfoList() NN_NOEXCEPT;
    void PollListChangedEvent() NN_NOEXCEPT;

private:
    static void ProcessReadAocInfoListStatic(void* inPtr) NN_NOEXCEPT;
    int StartReadAocInfoListAsync() NN_NOEXCEPT;
    void StopReadAocInfoListAsync() NN_NOEXCEPT;

private:
    static void ProcessPollListChangedEventStatic(void* inPtr) NN_NOEXCEPT;
    int StartPollListChangedEvent() NN_NOEXCEPT;
    void StopPollListChangedEvent() NN_NOEXCEPT;

private:
    // AocInfo画面ページ全体の状態定義
    enum State
    {
        State_None,
        State_CalcHash,
        State_CalcProcessing,
        State_CalcEnd,
    };

    State m_State;

    // Aoc一覧表示の最大行数定義
    static const int MaxItemCount = 8;

    bool m_HasAoc;
    int m_CurrentSelectPos;
    int m_CurrentMaxPosNum;
    int m_CurrentPage;
    int m_LastPage;

    std::vector<AocInfoProperty> m_AocInfoList;

    Hash m_Hash;
    int m_CalcCount;
    int m_Progress;
    AocInfoProperty* m_CalcPropertyPtr;

    SceneCommon::TouchRange m_AocRangeList[MaxItemCount];
    SceneCommon::TouchRange m_CalculateRange;
    SceneCommon::TouchRange m_BackPageRange;
    SceneCommon::TouchRange m_NextPageRange;

    SceneCommon::RangePackage m_ReloadRange;

private:
    nn::os::ThreadType m_AocInfoReadThread;

    bool m_IsReadingAocInfo;
    bool m_IsStopReading;

    int m_TotalAocCount;
    int m_ReadAocCount;
    int m_ReadingCalcCount;

private:
    bool m_IsBlinkReloadButton;
    int m_ChangedEventCalcCount;

    nn::os::ThreadType m_PollingListChangedEventThread;

    bool m_IsPollingListChangedEvent;
    bool m_IsStopPolling;
};
