﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Xml.Serialization;

namespace PCToolTester.JUnit
{
    [SerializableAttribute()]
    public enum ItemStates
    {
        error,
        failure,
    }

    [SerializableAttribute()]
    public enum ItemKinds
    {
        testcase,
    }

    [System.SerializableAttribute()]
    public class testcase
    {
        [XmlElementAttribute("error", typeof(error))]
        [XmlElementAttribute("failure", typeof(failure))]
        [XmlChoiceIdentifierAttribute("ItemsState")]
        public object[] Items { get; set; }

        [XmlIgnoreAttribute()]
        public ItemStates[] ItemsState { get; set; }

        [XmlAttributeAttribute()]
        public string name { get; set; }

        [XmlAttributeAttribute()]
        public string time { get; set; }
    }

    [SerializableAttribute()]
    public class testsuite
    {
        [XmlElementAttribute("testcase", typeof(testcase))]
        [XmlChoiceIdentifierAttribute("ItemsKind")]
        public object[] Items { get; set; }

        [XmlElementAttribute("ItemsKind")]
        [XmlIgnoreAttribute()]
        public ItemKinds[] ItemsKind { get; set; }

        [XmlAttributeAttribute()]
        public string time { get; set; }

        [XmlAttributeAttribute()]
        public string tests { get; set; }

        [XmlAttributeAttribute()]
        public string failures { get; set; }

        [XmlAttributeAttribute()]
        public string errors { get; set; }
    }

    [System.SerializableAttribute()]
    public class failure
    {
        [XmlAttributeAttribute()]
        public string Kind { get; set; }

        [XmlAttributeAttribute()]
        public string message { get; set; }

        [XmlTextAttribute()]
        public string[] Text { get; set; }
    }

    [System.SerializableAttribute()]
    public class error
    {
        [XmlAttributeAttribute()]
        public string Kind { get; set; }

        [XmlAttributeAttribute()]
        public string message { get; set; }

        [XmlTextAttribute()]
        public string[] Text { get; set; }
    }
}
