﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace NintendoWare.Spy.Extensions.Tests
{
    [TestClass()]
    public class ArrayExtensionTests
    {
        [TestMethod()]
        public void PopulateTest()
        {
            var array = new int[3].Populate(5);
            Assert.AreEqual(3, array.Length);
            Assert.AreEqual(5, array[0]);
            Assert.AreEqual(5, array[1]);
            Assert.AreEqual(5, array[2]);
        }

        [TestMethod()]
        public void PopulateTest1()
        {
            var array1 = new int[3].Populate(_ => 5);
            Assert.AreEqual(3, array1.Length);
            Assert.AreEqual(5, array1[0]);
            Assert.AreEqual(5, array1[1]);
            Assert.AreEqual(5, array1[2]);

            var array2 = new int[3].Populate(i => i * i + 5);
            Assert.AreEqual(5, array2[0]);
            Assert.AreEqual(6, array2[1]);
            Assert.AreEqual(9, array2[2]);
        }
    }
}
