﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.IO;
using System.Linq;

namespace Nintendo.Atk.Tests
{
    internal static class FileComparer
    {
        internal static void CompareFile(string expectedFilePath, string actualFilePath)
        {
            Assert.IsTrue(File.Exists(expectedFilePath));
            Assert.IsTrue(File.Exists(actualFilePath));

            using (var expectedReader = new BinaryReader(File.OpenRead(expectedFilePath)))
            {
                using (var actualReader = new BinaryReader(File.OpenRead(actualFilePath)))
                {
                    Assert.AreEqual(expectedReader.BaseStream.Length, actualReader.BaseStream.Length);

                    var restLength = expectedReader.BaseStream.Length;

                    while (restLength > 0)
                    {
                        // 4KB ずつ比較する
                        var readLength = (int)Math.Min(restLength, 4 * 1024);
                        restLength -= readLength;

                        var expectedBytes = expectedReader.ReadBytes(readLength);
                        var actualBytes = actualReader.ReadBytes(readLength);

                        foreach (var index in Enumerable.Range(0, readLength))
                        {
                            Assert.AreEqual(expectedBytes[index], actualBytes[index], actualFilePath);
                        }
                    }
                }
            }
        }
    }
}
