﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sdmmc0/sdmmc_Api.h>
#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <iostream>
#include <nnt/result/testResult_Assert.h>
#include <memory>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Result.h>
#include <nn/util/util_BitUtil.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_CharacterEncoding.h>
#include <nn/result/result_HandlingUtility.h>

#include <Utility/systemInitializer_Crc32.h>
#include <Utility/systemInitializer_IBlockStorage.h>
#include <Utility/systemInitializer_IFile.h>
#include <Utility/systemInitializer_Allocator.h>
#include "Utility/systemInitializer_FileSystemUtility.h"
#include <InitialImage/systemInitializer_InitialImage.h>
#include <Partition/systemInitializer_Partition.h>
#include <tool_SystemInitializer.h>
#include <Utility/systemInitializer_FsFile.h>
#include <nn/utilTool/utilTool_CommandLog.h>


TEST(SystemInitializerTest, MatchPattern)
{
    EXPECT_TRUE(IsValidFileSystemEntry("host:/"));
    EXPECT_FALSE(IsValidFileSystemEntry("host"));
}

#if 0

TEST(SystemInitializerTest, TmHostFs)
{
    nn::fs::SetAllocator(Allocate, Deallocate);
    NN_UTILTOOL_ABORT_UNLESS_RESULT_SUCCESS(
        nn::fs::MountHostRoot());

    const size_t StorageWritingBufferSize = 16 * 1024 * 1024;
    NN_ALIGNAS(4096) static uint8_t s_StorageWritingBuffer[StorageWritingBufferSize];

    FsFile file;
    NN_UTILTOOL_ABORT_UNLESS_RESULT_SUCCESS(
        file.OpenRead("D:\\home\\siglo\\sdk\\Programs\\Eris\\Outputs\\jetson-tk2-kernel\\InitialImages\\InitializedJetsonTk2\\Develop\\InitializedJetsonTk2.initimg"));
    NN_UTIL_SCOPE_EXIT { file.Close(); };

    size_t readSize;
    uint64_t currentOffset = 0; //20560512;
    uint32_t writeChunkSize = 4192256;

    NN_UTILTOOL_ABORT_UNLESS_RESULT_SUCCESS(file.Read(&readSize, currentOffset, s_StorageWritingBuffer, writeChunkSize));

}

#endif

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);
    nnt::Exit(RUN_ALL_TESTS());
}
