﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <InstallNspOnHost.h>

#include <algorithm>
#include <cstdarg>
#include <string>
#include <vector>
#include <memory>

#include <nn/cstd/cstd_CStdArg.h>
#include <nn/fs.h>
#include <nn/fs/fs_Bis.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentMetaDatabaseImpl.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/ncm/ncm_ContentStorageImpl.h>
#include <nn/ncm/ncm_IContentStorage.h>
#include <nn/ncm/ncm_Result.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/ncm/ncm_SubmissionPackageInstallTask.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_TFormatString.h>
#include <nn/utilTool/utilTool_CommandInterface.h>
#include <nn/utilTool/utilTool_CommandLog.h>
#include <nnt.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/nntest.h>
#include <nnt/teamcity/testTeamcity_Logger.h>

namespace{

    void* Allocate(size_t size)
    {
        return malloc(size);
    }

    void Deallocate(void* p, size_t size)
    {
        NN_UNUSED(size);
        return free(p);
    }

} // namespace

class InstallNspOnHostTest : public testing::Test
{
protected:
    static void SetUpTestCase()
    {
        nn::utilTool::DefaultCommandLogObserver defaultObserver;
        defaultObserver.SetPositionDisplay(false);
        defaultObserver.SetLevel(nn::utilTool::CommandLogLevel_Debug);
        nn::utilTool::RegisterCommandLogObserver(defaultObserver);
        NN_UTIL_SCOPE_EXIT{ nn::utilTool::UnregisterCommandLogObserver(defaultObserver); };

        nn::fs::SetAllocator(Allocate, Deallocate);
        nn::fs::MountHostRoot();

        std::vector<std::string> restArgs;
        nn::utilTool::SingleCommandInterface commandInterface;
        commandInterface.AddKeywordArgument(&s_OutputDirectory, 'o', "output-directory", "", true);
        commandInterface.AddKeywordArgument(&s_TestNspPath, "nsp-path", "", true);
        commandInterface.SetVariableArguments(&restArgs, "rest args", "", false);
        NN_ABORT_UNLESS(commandInterface.TryParse(nnt::GetHostArgc(), const_cast<const char**>(nnt::GetHostArgv())));
    }

    static void TearDownTestCase()
    {
        nn::fs::UnmountHostRoot();
    }

    virtual void SetUp()
    {
        nn::fs::DeleteDirectoryRecursively(s_OutputDirectory.c_str());
        nn::fs::CreateDirectory(s_OutputDirectory.c_str());
    }

    virtual void TearDown()
    {
        nn::fs::DeleteDirectoryRecursively(s_OutputDirectory.c_str());
    }

    const char* GetOutputDirectory()
    {
        return s_OutputDirectory.c_str();
    }

    const char* GetNspPath()
    {
        return s_TestNspPath.c_str();
    }

    static std::string s_OutputDirectory;
    static std::string s_TestNspPath;
};

std::string InstallNspOnHostTest::s_OutputDirectory;
std::string InstallNspOnHostTest::s_TestNspPath;

TEST_F(InstallNspOnHostTest, TestBasic)
{
    NNT_EXPECT_RESULT_SUCCESS(
        InstallNsp("system", GetOutputDirectory(), GetNspPath()));
}
