﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyNintendoSdkSubDevelopmentRoot : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (SdkRootInfo.Environment)
            {
                case SdkEnvironment.Development:
                    switch (conf.SubRootName)
                    {
                        case "Alice":
                        case "Chris":
                        case "Eris":
                        case "Iris":
                        case "NintendoWare":
                            AssertArePathsEqual(expander,
                                @"$(SdkRoot)\$(SubRootRelativeDir)",
                                ep.Properties["NintendoSdkSubDevelopmentRoot"]);
                            break;
                        case "Samples":
                        case "Tests":
                        case "Users":
                            // $(NintendoSdkSubDevelopmentRoot) は使用しない
                            Assert.False(ep.Properties.ContainsKey("NintendoSdkSubDevelopmentRoot"));
                            break;
                        default:
                            Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                            break;
                    }
                    break;
                case SdkEnvironment.User:
                    // $(NintendoSdkSubDevelopmentRoot) は使用しない
                    Assert.False(ep.Properties.ContainsKey("NintendoSdkSubDevelopmentRoot"));
                    break;
                default:
                    Assert.True(false, string.Format("未知の SdkEnvironment です: {0}", SdkRootInfo.Environment));
                    break;
            }
        }
    }
}
