﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyNintendoSdkSpecFilesDirectory : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (conf.ProjectType == ProjectType.Library)
            {
                return;
            }
            if (!(conf.Platform == "NX32" || conf.Platform == "NX64"))
            {
                return;
            }

            switch (conf.SubRootName)
            {
                case "Users":
                    InvokeUserEnvironmentAssertions(conf, ep, expander);
                    break;
                case "Samples":
                    switch (SdkRootInfo.Environment)
                    {
                        case SdkEnvironment.Development:
                            InvokeDevelopmentEnvironmentAssertions(conf, ep, expander);
                            break;
                        case SdkEnvironment.User:
                            InvokeUserEnvironmentAssertions(conf, ep, expander);
                            break;
                        default:
                            Assert.True(false, string.Format("未知の SDK 環境です: {0}", SdkRootInfo.Environment));
                            break;
                    }
                    break;
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Tests":
                    // don't care
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }

        private void InvokeDevelopmentEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertArePathsEqual(
                expander,
                @"$(SdkRoot)\Programs\Iris\Resources\SpecFiles",
                ep.Properties["NintendoSdkSpecFilesDirectory"]);
        }

        private void InvokeUserEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            AssertArePathsEqual(
                expander,
                @"$(SdkRoot)\Resources\SpecFiles",
                ep.Properties["NintendoSdkSpecFilesDirectory"]);
        }
    }
}
