﻿using System;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyNintendoSdkDllSuffix : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.Platform)
            {
                case "Win32":
                case "x64":
                    Assert.Equal(".dll", ep.Properties["NintendoSdkDllSuffix"]);
                    break;
                case "NX32":
                case "NX64":
                    Assert.Equal(".nso", ep.Properties["NintendoSdkDllSuffix"]);
                    break;
                default:
                    Assert.True(false, string.Format($"未知の Platform です: {conf.Platform}"));
                    break;
            }
        }
    }
}
