﻿using System;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyDynamicSymbolList : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (SdkRootInfo.Environment)
            {
                case SdkEnvironment.Development:
                    AssertArePathsEqual(expander,
                        @"$(SdkRoot)\Programs\Iris\Resources\SpecFiles\ExportDynamicSymbol.lst",
                        ep.Properties["DynamicSymbolList"]);
                    break;
                case SdkEnvironment.User:
                    AssertArePathsEqual(expander,
                        @"$(SdkRoot)\Resources\SpecFiles\ExportDynamicSymbol.lst",
                        ep.Properties["DynamicSymbolList"]);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SdkEnvironment です: {0}", SdkRootInfo.Environment));
                    break;
            }
        }
    }
}
